package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.BaseAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;

import java.util.Collection;
import java.util.Map;

/**
 * Created by aleksart on 14.02.14.
 */
public class AddPropertiesProcessor extends EntityProcessor {

    private Map<String, BaseAttrValue> newProperties;

    public AddPropertiesProcessor(Map newProperties){
        this.newProperties = newProperties;
    }

    @Override
    public Collection<Entity> process(Entity ee) {
        BaseMutableEntity e = new BaseMutableEntity(ee);
        for(String prop: newProperties.keySet()){
            e.setValue(prop, newProperties.get(prop));
        }
        return Cf.<Entity>list(e);
    }
}
