package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors;

import ru.yandex.common.util.collections.Cu;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;

import java.util.*;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12.12.13
 * Time: 13:41
 */
public class CascadeEntityProcessor extends EntityProcessor {

    private final Set<EntityProcessor> processors;

    public CascadeEntityProcessor(final Set<EntityProcessor> processors) {
        this.processors = processors;
    }

    @Override
    public Collection<Entity> process(final Entity e) {
        List<Entity> result = new ArrayList<>();
        result.add(e);
        for (final EntityProcessor processor : processors) {
            result = Cu.join(Cu.map(processor, result));
        }
        return Collections.unmodifiableCollection(result);
    }
}
