package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors;


import ru.yandex.webmaster3.core.semantic.data_reactor_common.BaseAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.EntityAttrValue;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Created by aleksart on 03.06.14.
 */
public class ImplProcessProcessor extends EntityProcessor {

    private EntityProcessor processor;
    private String inputTag;
    private String outputTag;

    public ImplProcessProcessor(EntityProcessor processor, String inputTag, String outputTag) {
        this.processor = processor;
        this.inputTag = inputTag;
        this.outputTag = outputTag;
    }

    @Override
    public Collection<Entity> process(Entity e) {
        Collection<Entity> result = new ArrayList<>();
        BaseMutableEntity eo = new BaseMutableEntity(e);
        for (BaseAttrValue attrValue : e.getValues(inputTag)) {
            if (attrValue instanceof EntityAttrValue) {
                EntityAttrValue entityAttrValue = (EntityAttrValue) attrValue;
                BaseMutableEntity attrValueEntity = new BaseMutableEntity(entityAttrValue.entity);
                for(Entity ep : processor.process(attrValueEntity)){
                    eo.appendValue(outputTag, new EntityAttrValue(ep));
                }
            }
        }
        result.add(eo);

        return result;
    }
}
