package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors;


import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.BaseAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.EntityAttrValue;

import java.util.Collection;
import java.util.Collections;

/**
 * Created by aleksart on 03.06.14.
 */
public class ImplReplaceProcessProcessor extends EntityProcessor {

    private EntityProcessor processor;
    private String inputTag;
    private String outputTag;

    public ImplReplaceProcessProcessor(EntityProcessor processor, String inputTag, String outputTag) {
        this.processor = processor;
        this.inputTag = inputTag;
        this.outputTag = outputTag;
    }

    @Override
    public Collection<Entity> process(Entity e) {
        Entity eo = new BaseMutableEntity(e);
        eo.setValues(inputTag, Collections.<BaseAttrValue>emptyList());
        for (BaseAttrValue attrValue : e.getValues(inputTag)) {
            if (attrValue instanceof EntityAttrValue) {
                EntityAttrValue entityAttrValue = (EntityAttrValue) attrValue;
                BaseMutableEntity attrValueEntity = new BaseMutableEntity(entityAttrValue.entity);
                for (Entity ep : processor.process(attrValueEntity)) {
                    eo.appendValue(outputTag, new EntityAttrValue(ep));
                }
            }
        }

        return Cf.list(eo);
    }
}
