package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;

import java.util.*;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12.12.13
 * Time: 13:34
 */
public class MapEntityProcessor extends EntityProcessor {

    private final Set<EntityProcessor> processors;

    public MapEntityProcessor(final Set<EntityProcessor> processors) {
        this.processors = processors;
    }

    @Override
    public Collection<Entity> process(final Entity e) {
        final List<Entity> result = new ArrayList<>();
        for (final EntityProcessor processor : processors) {
            result.addAll(processor.process(e));
        }
        return Collections.unmodifiableCollection(result);
    }
}
