package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.BaseAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.EntityAttrValue;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 31.10.14
 * Time: 5:50
 */
public class MassImplReplaceProcessor extends EntityProcessor {

    final List<String> tagList;
    final EntityProcessor processor;

    public MassImplReplaceProcessor(final List<String> tagList, final EntityProcessor processor) {
        this.tagList = tagList;
        this.processor = processor;
    }

    @Override
    public Collection<Entity> process(final Entity e) {
        Entity eo = new BaseMutableEntity(e);
        for (String tag : tagList) {
            eo.setValues(tag, Collections.<BaseAttrValue>emptyList());
            for (BaseAttrValue attrVal : e.getValues(tag)) {
                if (attrVal instanceof EntityAttrValue) {
                    for (Entity re : processor.process(((EntityAttrValue) attrVal).entity)) {
                        eo.appendValue(tag, new EntityAttrValue(re));
                    }
                } else {
                    eo.appendValue(tag, attrVal);
                }
            }
        }
        return Cf.list(eo);
    }
}
