package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12.12.13
 * Time: 13:31
 */
public class TagableProcessorWrapper extends EntityProcessor {

    private final Set<String> tags;
    private final EntityProcessor processor;

    public TagableProcessorWrapper(final Set<String> tags, final EntityProcessor processor) {
        this.tags = tags;
        this.processor = processor;
    }

    public TagableProcessorWrapper(final String tag, final EntityProcessor processor) {
        this.processor = processor;
        tags = Cf.set(tag);
    }

    @Override
    public Collection<Entity> process(final Entity e) {
        if (tags.contains(e.getTag())) {
            return processor.process(e);
        } else {
            return Collections.EMPTY_SET;
        }
    }
}
