package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.*;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.EntityAttrValue;

import java.util.*;

/**
 * Created by aleksart on 27.12.13.
 */
public class ZipperProcessor extends EntityProcessor {
    Map<String, String> patterns;

    public ZipperProcessor(Map patterns) {
        this.patterns = patterns;
    }

    @Override
    public Collection<Entity> process(Entity e) {

        BaseMutableEntity result = new BaseMutableEntity(e.tag, e.url);
        List<BaseAttrValue> attrValueList;

        Set<String> paths = patterns.keySet();

        for (String path : paths) {
            String[] sPath = path.split("/");
            attrValueList = e.getValues(sPath[0]);
            if (sPath.length > 1) {
                for (int depth = 1; depth < sPath.length; depth++) {
                    List<BaseAttrValue> newAttrValueList = new ArrayList<>();
                    for (BaseAttrValue attr : attrValueList) {
                        if (attr instanceof EntityAttrValue) {
                            newAttrValueList.addAll((((EntityAttrValue) attr).entity).getValues(sPath[depth]));
                        }
                    }
                    attrValueList = newAttrValueList;
                    if (depth == sPath.length - 1) {
                        for (BaseAttrValue newAttr : newAttrValueList) {
                            result.appendValue(patterns.get(path), newAttr);
                        }
                    }
                }
            } else {
                for (BaseAttrValue newAttr : attrValueList) {
                    result.appendValue(patterns.get(path), newAttr);
                }
            }

        }
        Collection<Entity> resultList = new ArrayList<>();
        resultList.add(result);
        if (resultList.isEmpty()) {
            return Collections.EMPTY_LIST;
        } else {
            return resultList;
        }
    }

}
