package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.article;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by aleksart on 08.07.14.
 */
public class EncArticleFromSchema extends EntityProcessor {

    private static final Map<String, String> ENC_ARTICLE_ZIP_MAP = new HashMap<>();

    static {
        ENC_ARTICLE_ZIP_MAP.put("title/data", "title");
        ENC_ARTICLE_ZIP_MAP.put("headline/data", "title");
        ENC_ARTICLE_ZIP_MAP.put("content/html", "contento");
        ENC_ARTICLE_ZIP_MAP.put("articleBody/html", "contento");
        ENC_ARTICLE_ZIP_MAP.put("category/data", "category");
        ENC_ARTICLE_ZIP_MAP.put("articleSection/data", "category");
        ENC_ARTICLE_ZIP_MAP.put("references/data", "references");
        ENC_ARTICLE_ZIP_MAP.put("author/data", "author");
        ENC_ARTICLE_ZIP_MAP.put("source/data", "source");
        ENC_ARTICLE_ZIP_MAP.put("source-date/data", "source-date");
        ENC_ARTICLE_ZIP_MAP.put("datePublished/data", "source-date");
        ENC_ARTICLE_ZIP_MAP.put("photo/href", "photo");
        ENC_ARTICLE_ZIP_MAP.put("image/href", "photo");
        ENC_ARTICLE_ZIP_MAP.put("sourceUrl", "source-url");
        ENC_ARTICLE_ZIP_MAP.put("sourceType", "source-type");
    }

    private static final EntityProcessor ENC_ARTICLE_ZIPPER = new ZipperProcessor(ENC_ARTICLE_ZIP_MAP);

    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if (itemTypeAttribute != null) {
            String itemtype = itemTypeAttribute.getContent();
            if ("http://webmaster.yandex.ru/vocabularies/enc-article.xml".equals(itemtype) ||
                    "http://schema.org/ScholarlyArticle".equals(itemtype)) {
                String sourceType =
                        "http://schema.org/ScholarlyArticle".equals(itemtype) ? "scholarly-article" : "enc-article";
                BaseMutableEntity encArticleOrgEntity = new BaseMutableEntity(e, "EncArticleOrgEntity");
                encArticleOrgEntity.setValue("sourceUrl", new StringAttrValue(encArticleOrgEntity.getUrl()));
                encArticleOrgEntity.setValue("sourceType", new StringAttrValue(sourceType));
                return ENC_ARTICLE_ZIPPER.process(encArticleOrgEntity);
            }
        }
        return Collections.EMPTY_LIST;
    }
}
