package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.article;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;

import java.util.*;

/**
 * Created by aleksart on 08.07.14.
 */
public class TermDefFromYandex extends EntityProcessor {

    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if(itemTypeAttribute != null){
            String itemtype = itemTypeAttribute.getContent();
            if("http://webmaster.yandex.ru/vocabularies/term-def.xml".equals(itemtype)){
                BaseMutableEntity encArticleOrgEntity = new BaseMutableEntity(e,"TermDefOrgEntity");
                encArticleOrgEntity.setValue("sourceUrl", new StringAttrValue(encArticleOrgEntity.getUrl()));
                Map<String,String> mzips = new HashMap();
                mzips.put("term/data","term");
                mzips.put("definition/html","contento");
                mzips.put("author/data","author");
                mzips.put("source/data","source");

                mzips.put("source-date/data","source-date");
                mzips.put("datePublished/data","source-date");

                mzips.put("sourceUrl","source-url");
                EntityProcessor zipper = new ZipperProcessor(mzips);
                Collection<Entity> result = zipper.process(encArticleOrgEntity);
                return result;
            }
        }
        return Collections.EMPTY_LIST;
    }
}
