package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.auto;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by aleksart on 10.07.14.
 */
public class AutoFromSchema extends EntityProcessor {

    public final static AutoFromSchema instance = new AutoFromSchema();
    private static final Map<String,String> AUTO_ZIP_MAP = new HashMap<>();

    static {
        AUTO_ZIP_MAP.put("bodyType/data", "body-type");
        AUTO_ZIP_MAP.put("brand/data", "brand");
        AUTO_ZIP_MAP.put("model/data", "model");
        AUTO_ZIP_MAP.put("configurationName/data", "config-name");
        AUTO_ZIP_MAP.put("displacement/data", "displacement");
        AUTO_ZIP_MAP.put("engineType/data", "engine-type");
        AUTO_ZIP_MAP.put("name/data", "name");
        AUTO_ZIP_MAP.put("gearType/data", "gear-type");
        AUTO_ZIP_MAP.put("prodyear/data", "prodyear");
        AUTO_ZIP_MAP.put("steeringWheel/data", "steering-wheel");
        AUTO_ZIP_MAP.put("transmission/data", "transmission");
        AUTO_ZIP_MAP.put("url/href", "url");
        AUTO_ZIP_MAP.put("url/data", "url");
    }

    private static final EntityProcessor AUTO_ZIPPER = new ZipperProcessor(AUTO_ZIP_MAP);

    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if(itemTypeAttribute != null){
            String itemtype = itemTypeAttribute.getContent();
            if("http://schema.org/Auto".equals(itemtype)||"http://schema.org/Car".equals(itemtype)) {
                return AUTO_ZIPPER.process(new BaseMutableEntity(e,"AutoEntity"));
            }
        }
        return Collections.EMPTY_LIST;
    }
}
