package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.auto;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ImplProcessProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.organization.AuthorFromSchema;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.utils.ProcessorUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by aleksart on 10.07.14.
 */
public class AutoReviewFromSchema extends EntityProcessor {

    private final static EntityProcessor ITEM_REVIEWED_PROCESSOR = new ImplProcessProcessor(AutoFromSchema.instance,"itemReviewed","item");
    private final static EntityProcessor AUTHOR_PROCESSOR = new ImplProcessProcessor(AuthorFromSchema.instance,"author","review-author");
    private static final Map<String,String> AUTO_REVIEW_ZIP_MAP = new HashMap<>();

    static {
        AUTO_REVIEW_ZIP_MAP.put("url/href", "url");
        AUTO_REVIEW_ZIP_MAP.put("url/data", "url");
        AUTO_REVIEW_ZIP_MAP.put("pro/data", "pro");
        AUTO_REVIEW_ZIP_MAP.put("contra/data", "contra");
        AUTO_REVIEW_ZIP_MAP.put("reviewBody/data", "review-body");
        AUTO_REVIEW_ZIP_MAP.put("description/data", "description");
        AUTO_REVIEW_ZIP_MAP.put("name/data", "name");
        AUTO_REVIEW_ZIP_MAP.put("reviewRating/bestRating/data", "best-rating");
        AUTO_REVIEW_ZIP_MAP.put("reviewRating/ratingValue/data", "rating");
        AUTO_REVIEW_ZIP_MAP.put("reviewRating/worstRating/data", "worst-rating");
        AUTO_REVIEW_ZIP_MAP.put("reviewRating/data", "rating");
        AUTO_REVIEW_ZIP_MAP.put("reviewsUrl/href", "reviewsUrl");
        AUTO_REVIEW_ZIP_MAP.put("reviewsUrl/data", "reviewsUrl");
        AUTO_REVIEW_ZIP_MAP.put("datePublished/data", "date-published");
    }

    private static final EntityProcessor AUTO_REVIEW_ZIPPER = new ZipperProcessor(AUTO_REVIEW_ZIP_MAP);

    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if(itemTypeAttribute != null){
            String itemtype = itemTypeAttribute.getContent();
            if("http://schema.org/Review".equals(itemtype)) {
                Entity review = new BaseMutableEntity(e,"AutoReviewOrgEntity");
                review = ProcessorUtils.getFirstOrStay(review,ITEM_REVIEWED_PROCESSOR);
                review = ProcessorUtils.getFirstOrStay(review,AUTHOR_PROCESSOR);
                Collection<Entity> result = AUTO_REVIEW_ZIPPER.process(review);
                return result;
            }
        }
        return Collections.EMPTY_LIST;
    }
}
