package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.creative;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;

import java.util.*;

import static ru.yandex.common.util.collections.CollectionFactory.newHashSet;

/**
 * Created by aleksart on 08.07.14.
 */
public class CreativeWorkFromSchema extends EntityProcessor {

    private static Set<String> CREATIVE_WORK_TYPES = newHashSet(
            Arrays.asList("CreativeWork", "Article", "BlogPosting", "NewsArticle", "ScholarlyArticle",
                    "MedicalScholarlyArticle", "Blog", "Book", "Diet", "ExercisePlan", "MediaObject", "AudioObject",
                    "ImageObject", "MusicVideoObject", "VideoObject", "Painting", "Photograph", "Sculpture",
                    "TVEpisode", "TVSeason", "TVSeries"));

    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if(itemTypeAttribute != null&&itemTypeAttribute.getContent()!=null){
            String itemtype = itemTypeAttribute.getContent();
            String clearType = itemtype.replace("http://schema.org/","");
            if(CREATIVE_WORK_TYPES.contains(clearType)) {

                BaseMutableEntity creativeWorkEntity = new BaseMutableEntity(e,"CreativeWorkOrgEntity");

                creativeWorkEntity.setValue("sourceUrl",new StringAttrValue(e.getUrl()));
                creativeWorkEntity.setValue("maintype", new StringAttrValue(clearType));
                creativeWorkEntity.setValue("language",new StringAttrValue(e.getStringValue("itemlang")));
                Map<String,String> zips = new HashMap<>();

                zips.put("author/data","author");
                zips.put("author/name/data","author");
                zips.put("description/data","description");
                zips.put("genre/data","genre");
                zips.put("headline/data","headline");
                zips.put("name/data","name");
                zips.put("sourceUrl","source-url");
                zips.put("maintype","mainType");
                zips.put("language","lang");
                EntityProcessor zipper = new ZipperProcessor(zips);
                Collection<Entity> result = zipper.process(creativeWorkEntity);
                return result;
            }
        }
        return Collections.EMPTY_LIST;
    }
}
