package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.movie;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.MassImplReplaceProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.SchemaProcessorsUtil;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.utils.ProcessorUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by aleksart on 03.07.14.
 */
public class MovieFromSchema extends EntityProcessor {

    private static final Map<String, String> MOVIE_ZIPPER = new HashMap<>();

    static {
        MOVIE_ZIPPER.put("name/data", "name");
        MOVIE_ZIPPER.put("productionCompany", "production-company");

        MOVIE_ZIPPER.put("duration/data", "duration");
        MOVIE_ZIPPER.put("description/data", "description");
        MOVIE_ZIPPER.put("trailer/href", "trailer");
        MOVIE_ZIPPER.put("alternativeHeadline/data", "alternative-headline");

        MOVIE_ZIPPER.put("contentRating", "content-rating");

        MOVIE_ZIPPER.put("dateCreated/data", "date-created");
        MOVIE_ZIPPER.put("dateModified/data", "date-modified");
        MOVIE_ZIPPER.put("datePublished/data", "date-published");

        MOVIE_ZIPPER.put("isFamilyFriendly", "is-family-friendly");
        MOVIE_ZIPPER.put("inLanguage", "in-language");
    }


    private final static EntityProcessor MOVIE_NAME_HREF_REPLACER = new MassImplReplaceProcessor(
            Cf.list("actor", "director", "musicBy", "producer", "productionCompany", "contentRating",
                    "isFamilyFriendly", "inLanguage", "version"), SchemaProcessorsUtil.HREF_TEXT_ZIPPER);
    private final static EntityProcessor MOVIE_DATA_REPLACER = new MassImplReplaceProcessor(
            Cf.list("award","awards","genre"), SchemaProcessorsUtil.DATA_ZIPPER);

    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if (itemTypeAttribute != null) {
            String itemtype = itemTypeAttribute.getContent();
            if ("http://schema.org/Movie".equals(itemtype)) {
                Entity movieEntity = new BaseMutableEntity(e, "MovieOrgEntity");
                movieEntity = ProcessorUtils.getFirstOrStay(movieEntity, MOVIE_NAME_HREF_REPLACER);
                movieEntity = ProcessorUtils.getFirstOrStay(movieEntity, MOVIE_DATA_REPLACER);
                movieEntity.appendValue("source-url", new StringAttrValue(movieEntity.url));
                EntityProcessor zipperMovie = new ZipperProcessor(MOVIE_ZIPPER);
                Collection<Entity> results = zipperMovie.process(movieEntity);
                return results;
            }
        }
        return Collections.EMPTY_LIST;
    }
}
