package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.music;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.*;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.EntityAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;

import java.util.*;


/**
 * Created by aleksart on 08.07.14.
 */
public class ChordsFromSchema extends EntityProcessor {
    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if (itemTypeAttribute != null&&itemTypeAttribute.getContent()!=null) {
            String itemtype = itemTypeAttribute.getContent();
            String clearType = itemtype.replace("http://schema.org/", "");
            if ("MusicRecording".equals(clearType)) {
                if (e.containAttribute("chordsLine") || e.containAttribute("chordsBlock")) {

                    BaseMutableEntity chordEntity = new BaseMutableEntity(e, "ChordsOrgEntity");

                    chordEntity.setValue("sourceUrl", new StringAttrValue(e.getUrl()));

                    Map<String, String> azips = new HashMap<>();

                    azips.put("name/data", "song_name");
                    azips.put("byArtist/data", "artist_name");
                    azips.put("byArtist/name/data", "artist_name");
                    azips.put("sourceUrl", "source-url");
                    azips.put("chordsBlock/html", "chords-block");
                    azips.put("chordsLine", "chords-line");

                    EntityProcessor zipper = new ZipperProcessor(azips);

                    Collection<Entity> result = zipper.process(chordEntity);

                    for (Entity r : result) {
                        String html = r.getStringValue("chords-block");

                        if (html != null) {
                            html = html.replaceAll("<[^>]*>", "");
                        }
                        if (r instanceof BaseMutableEntity) {
                            r.setValue("raw", new StringAttrValue(html));

                        }
                        if ((r instanceof BaseMutableEntity) && r.containAttribute("chords-line")) {
                            BaseMutableEntity tabs_text = new BaseMutableEntity("CHORDS", r.url);
                            r.setValue("CHORDS_TABS_TEXT", new EntityAttrValue(tabs_text));
                            for (BaseAttrValue attr : r.getValues("chords-line")) {
                                if (attr instanceof EntityAttrValue) {
                                    String ch = ((EntityAttrValue) attr).entity.getEntityValue("chords").getStringValue("html");
                                    String txt = ((EntityAttrValue) attr).entity.getEntityValue("text").getStringValue("html");
                                    ch = ch.replaceAll("<[^>]*>", "");
                                    txt = txt.replaceAll("<[^>]*>", "");
                                    tabs_text.setValue("chords", new StringAttrValue(ch));
                                    tabs_text.setValue("text", new StringAttrValue(txt));
                                }
                            }
                        }
                        ((BaseMutableEntity) r).clearAttribute("chords-block");
                    }

                    return result;
                }
            }
        }
        return Collections.EMPTY_LIST;
    }
}
