package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.music;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ImplReplaceProcessProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.utils.ProcessorUtils;

import java.util.*;

/**
 * Created by aleksart on 07.07.14.
 */
public class MusicGroupFromSchema extends EntityProcessor {

    private static final Map<String, String> MUSIC_GROUP_ZIP = new HashMap<>();

    static {
        MUSIC_GROUP_ZIP.put("name/data", "name");
        MUSIC_GROUP_ZIP.put("image/href", "image");
        MUSIC_GROUP_ZIP.put("recs", "musicrecording");
        MUSIC_GROUP_ZIP.put("interactionCount/data", "playcount");
        MUSIC_GROUP_ZIP.put("sourceUrl", "source-url");
    }

    private static final EntityProcessor MUSIC_GROUP_ZIPPER = new ZipperProcessor(MUSIC_GROUP_ZIP);
    private static final ImplReplaceProcessProcessor TRACKS_PROCESSOR =
            new ImplReplaceProcessProcessor(new MusicRecordingFromSchema(), "tracks", "recs");

    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if (itemTypeAttribute != null) {
            String itemtype = itemTypeAttribute.getContent();
            if ("http://schema.org/MusicGroup".equals(itemtype)) {
                Entity musicGroupEntity = new BaseMutableEntity(e, "MusicGroupOrgEntity");
                musicGroupEntity = ProcessorUtils.getFirstOrStay(musicGroupEntity, TRACKS_PROCESSOR);
                musicGroupEntity.setValue("sourceUrl", new StringAttrValue(musicGroupEntity.getUrl()));
                Collection<Entity> results = MUSIC_GROUP_ZIPPER.process(musicGroupEntity);
                MusicUtils.extractPlayCounts(results);
                return results;
            }
        } return Collections.EMPTY_LIST;
    }
}
