package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.music;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by aleksart on 08.07.14.
 */
public class MusicRecordingFromSchema extends EntityProcessor {
    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if(itemTypeAttribute != null){
            String itemtype = itemTypeAttribute.getContent();
            if("http://schema.org/MusicRecording".equals(itemtype)) {
                BaseMutableEntity musicRecordingEntity = new BaseMutableEntity(e,"MusicRecordingOrgEntity");
                Map<String,String> mzips = new HashMap();

                mzips.put("name/data","name");
                mzips.put("url/data","url");
                mzips.put("url/href","url");
                mzips.put("inAlbum/data","inalbum");
                mzips.put("duration/data","duration");
                mzips.put("interactionCount/data","playcount");
                EntityProcessor recZipper = new ZipperProcessor(mzips);
                Collection<Entity> result = recZipper.process(musicRecordingEntity);
                MusicUtils.extractPlayCounts(result);
                return result;
            }
        }
        return Collections.EMPTY_LIST;
    }


}
