package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.music;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;

import java.util.Collection;

/**
 * Created by aleksart on 08.07.14.
 */
public class MusicUtils {
    public static void extractPlayCounts(Collection<Entity> result) {
        for(Entity r : result){
            if(r instanceof BaseMutableEntity){
                String playCount;
                String interactioncount = r.getStringValue("playcount");
                if (interactioncount != null && interactioncount.startsWith("UserPlays:")) {
                    final String plays = interactioncount.substring("UserPlays:".length());
                    playCount = plays;
                } else {
                    playCount = null;
                }
                r.setValue("playcount", new StringAttrValue(playCount));
            }
        }
    }
}
