package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.organization;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;

import java.util.*;

/**
 * Created by aleksart on 30.05.14.
 */
public class AddressFromSchema extends EntityProcessor {
    @Override
    public Collection<Entity> process(Entity e) {

        BaseMutableEntity addressEntity = (BaseMutableEntity) e;
        Map<String, String> azips = new HashMap();

        azips.put("streetAddress/data", "street-address");
        azips.put("addressLocality/data", "locality");
        azips.put("addressCountry/data","country-name");
        azips.put("addressRegion/data", "region");
        azips.put("postalCode/data","postal-code");
        azips.put("postOfficeBoxNumber","post-office-box");

        azips.put("street-address/data", "street-address");
        azips.put("locality/data", "locality");
        azips.put("country-name/data","country-name");
        azips.put("region/data", "region");
        azips.put("postal-code/data","postal-code");
        azips.put("ppost-office-box","post-office-box");

        ZipperProcessor adrZipper = new ZipperProcessor(azips);
        return adrZipper.process(addressEntity);

    }
}
