package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.organization;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by aleksart on 04.06.14.
 */
public class AuthorFromSchema extends EntityProcessor {

    public final static AuthorFromSchema instance = new AuthorFromSchema();

    private static final Map<String,String> AUTHOR_ZIP_MAP = new HashMap<>();

    static {
        AUTHOR_ZIP_MAP.put("name/data", "fn");
        AUTHOR_ZIP_MAP.put("data", "fn");
        AUTHOR_ZIP_MAP.put("url/href", "url");
    }

    private static final ZipperProcessor AUTHOR_ZIPPER = new ZipperProcessor(AUTHOR_ZIP_MAP);

    @Override
    public Collection<Entity> process(Entity eAuthor) {
        return AUTHOR_ZIPPER.process(eAuthor);
    }
}
