package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.organization;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.EntityAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ImplProcessProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.utils.ProcessorUtils;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.MicrodataUtils;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.classificator.ItemTypeClassificator;

import java.util.*;

import static ru.yandex.common.util.StringUtils.isEmpty;

/**
 * Created by aleksart on 30.05.14.
 */
public class OrgFromSchema extends EntityProcessor {

    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if (itemTypeAttribute != null && itemTypeAttribute.getContent() != null) {
            String itemtype = itemTypeAttribute.getContent();
            String dict = null;
            if (itemtype.startsWith("http://data-vocabulary.org/")) {
                dict = "datavocab";
            } else if (itemtype.startsWith("http://schema.org/")) {
                dict = "schema.org";
            }
            final String kind = MicrodataUtils.extractType(itemtype);
            final String rootClass = ItemTypeClassificator.getRoot(kind);
            if (("Organization".equals(rootClass) || "Place".equals(rootClass)) && dict != null) {
                Entity orgEntity = new BaseMutableEntity(e, "OrganizationFromSchema");

                ImplProcessProcessor processor;

                EntityProcessor addressFromSchema = new AddressFromSchema();
                processor = new ImplProcessProcessor(addressFromSchema, "address", "address-adrs");
                orgEntity = ProcessorUtils.getFirstOrStay(orgEntity, processor);

                GeoFromSchema geoFromSchema = new GeoFromSchema();
                processor = new ImplProcessProcessor(geoFromSchema, "geo", "address-geo");
                orgEntity = ProcessorUtils.getFirstOrStay(orgEntity, processor);

                LocationFromSchema locationFromSchema = new LocationFromSchema();
                processor = new ImplProcessProcessor(locationFromSchema, "location", "address-geo");
                orgEntity = ProcessorUtils.getFirstOrStay(orgEntity, processor);

                BaseMutableEntity optEntity = new BaseMutableEntity("optParts", orgEntity.url);

                optEntity.setValue("source-format", new StringAttrValue(dict));
                orgEntity.setValue("opt-attr", new EntityAttrValue(optEntity));

                orgEntity.setValue("category", new StringAttrValue(kind));
                String catId = ItemTypeClassificator.getCat(kind);
                orgEntity.setValue("catId", new StringAttrValue(catId));
                if (isEmpty(orgEntity.getStringValue("name"))) {
                    return Collections.emptyList();
                }
                Map<String, String> izips = new HashMap<>();
                izips.put("email/data", "email");
                izips.put("address/data", "adrs");
                izips.put("address-adrs", "adrs");
                izips.put("address-geo", "geo");
                izips.put("address/telephone/data", "tel-voice");
                izips.put("telephone/data", "tel-voice");
                izips.put("faxNumber/data", "tel-fax");
                izips.put("name/data", "fn");
                izips.put("url/href", "url");
                izips.put("url/data", "url");
                izips.put("openingHours/data", "opening");
                izips.put("opt-attr", "opt-attr");
                izips.put("catId", "catId");

                ZipperProcessor zipperProcessor = new ZipperProcessor(izips);
                Collection<Entity> orgs = zipperProcessor.process(orgEntity);
                return orgs;
            }
        }
        return Collections.EMPTY_LIST;
    }

}
