package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.rating;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by aleksart on 08.07.14.
 */
public class AggregateRatingFromSchema extends EntityProcessor {
    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if(itemTypeAttribute != null){
            String itemtype = itemTypeAttribute.getContent();
            if("http://schema.org/AggregateRating".equals(itemtype)) {
                BaseMutableEntity aggregateRatingEntity = new BaseMutableEntity(e,"AggregateRatingOrgEntity");

                aggregateRatingEntity.setValue("sourceUrl",new StringAttrValue(e.getUrl()));

                Map<String,String> mzips = new HashMap();

                mzips.put("bestRating/data","best-rating");
                mzips.put("ratingCount/data","rating-count");
                mzips.put("ratingValue/data","rating-value");
                mzips.put("reviewCount/data","review-count");
                mzips.put("worstRating/data","worst-rating");
                mzips.put("sourceUrl","source-url");

                EntityProcessor zipper = new ZipperProcessor(mzips);
                Collection<Entity> result = zipper.process(aggregateRatingEntity);
                return result;
            }

        }
        return Collections.EMPTY_LIST;
    }
}
