package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.rating;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.BaseAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;

import java.util.*;

/**
 * Created by aleksart on 19.02.14.
 */
public class OrgRatingFromSchemaOrgTagProcessor extends EntityProcessor {
    @Override
    public Collection<Entity> process(Entity e) {

        BaseAttrValue itemtype = e.getFirstOrNull("@itemtype");
        if(itemtype instanceof StringAttrValue){
            String item = ((StringAttrValue) itemtype).getContent();
            if("http://schema.org/Rating".equals(item)){
                Map<String,String> zips = new HashMap<>();
                zips.put("ratingValue/data","value");
                zips.put("bestRating/data","best");
                zips.put("worstRating/data","worst");
                zips.put("ratingTarget/data","name");
                zips.put("ratingTarget/href","name");
                ZipperProcessor zipperProcessor = new ZipperProcessor(zips);
                Collection<Entity> zippedEnt = zipperProcessor.process(e);
                Collection<Entity> result = new ArrayList<>();

                for(Entity ee: zippedEnt ){
                    RatingNormalizationProcessor ratingProcessor = new RatingNormalizationProcessor();
                    result.addAll(ratingProcessor.process(ee));

                }
                return result;
            }
        }

        return Collections.EMPTY_LIST;
    }
}
