package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.recipe;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.EntityProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ImplProcessProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.organization.AuthorFromSchema;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.utils.ProcessorUtils;

import java.util.*;

/**
 * Created by aleksart on 07.07.14.
 */
public class RecipeFromSchema extends EntityProcessor {

    private static final Map<String, String> RECIPE_ZIP_MAP = new HashMap<>();

    static {
        RECIPE_ZIP_MAP.put("name/data", "name");
        RECIPE_ZIP_MAP.put("ingr", "ingredient");
        RECIPE_ZIP_MAP.put("recipeInstructions/data", "instruction");
        RECIPE_ZIP_MAP.put("recipeCategory/data", "category");
        RECIPE_ZIP_MAP.put("recipeYield/data", "yield");
        RECIPE_ZIP_MAP.put("totalTime/data", "duration");
        RECIPE_ZIP_MAP.put("cookTime/data", "duration");
        RECIPE_ZIP_MAP.put("prepTime/data", "duration");
        RECIPE_ZIP_MAP.put("image/href", "photo");
        RECIPE_ZIP_MAP.put("resultPhoto/href", "result-photo");
        RECIPE_ZIP_MAP.put("author-reviewer/fn", "author");
        RECIPE_ZIP_MAP.put("nutr", "nutrition");
        RECIPE_ZIP_MAP.put("recipeCusine/data", "cuisine-type");
        RECIPE_ZIP_MAP.put("srcUrl", "source-url");
    }

    private static final EntityProcessor RECIPE_ZIPPER = new ZipperProcessor(RECIPE_ZIP_MAP);
    private static final Map<String, String> NUTRITIONS_ZIP_MAP = new HashMap<>();

    static {
        final String[] CONTENT_TYPES =
                {"carbohydrate", "cholesterol", "fat", "fiber", "protein", "saturatedFat", "sodium", "sugar",
                        "transFat", "unsaturatedFat"};
        for (String type : CONTENT_TYPES) {
            NUTRITIONS_ZIP_MAP.put(type + "Content/data", type);
        }
    }

    private static final EntityProcessor NUTRITION_ZIPPER = new ZipperProcessor(NUTRITIONS_ZIP_MAP);
    private final static EntityProcessor NUTRITION_PROCESSOR =
            new ImplProcessProcessor(NUTRITION_ZIPPER, "nutrition", "nutr");
    private final static EntityProcessor AUTHOR_PROCESSOR =
            new ImplProcessProcessor(new AuthorFromSchema(), "author", "author-reviewer");

    private final static Map<String, String> INGRIDIENT_ZIP_MAP = new HashMap<>();

    static {
        INGRIDIENT_ZIP_MAP.put("data", "name");
    }

    private final static EntityProcessor INGRIDIENTS_PROCESSOR =
            new ImplProcessProcessor(new ZipperProcessor(INGRIDIENT_ZIP_MAP), "ingredients", "ingr");

    @Override
    public Collection<Entity> process(Entity e) {
        StringAttrValue itemTypeAttribute = (StringAttrValue) e.getFirstOrNull("@itemtype");
        if (itemTypeAttribute != null) {
            String itemtype = itemTypeAttribute.getContent();
            if ("http://schema.org/Recipe".equals(itemtype)) {
                Entity recipeEntity = new BaseMutableEntity(e, "RecipeOrgEntity");
                recipeEntity = ProcessorUtils.getFirstOrStay(recipeEntity, INGRIDIENTS_PROCESSOR);
                recipeEntity = ProcessorUtils.getFirstOrStay(recipeEntity, AUTHOR_PROCESSOR);
                recipeEntity = ProcessorUtils.getFirstOrStay(recipeEntity, NUTRITION_PROCESSOR);
                recipeEntity.appendValue("srcUrl", new StringAttrValue(recipeEntity.getUrl()));
                Collection<Entity> results = RECIPE_ZIPPER.process(recipeEntity);
                return results;
            }
        }
        return Collections.EMPTY_LIST;
    }
}
