package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.review;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.*;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.EntityAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ImplProcessProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.ZipperProcessor;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.organization.AuthorFromSchema;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.organization.OrgFromSchema;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.processors.schemaorg.rating.OrgRatingFromSchemaOrgTagProcessor;

import java.util.*;

/**
 * Created by aleksart on 19.02.14.
 */
public class OrgReviewFromSchemaOrgProcessor extends EntityProcessor {

    private static final Map<String,String> ZIPS = new HashMap<>();
    static {
        ZIPS.put("tag-tags", "tags");
        ZIPS.put("reviewRating/bestRating/data", "best-rating");
        ZIPS.put("reviewRating/ratingValue/data", "rating");
        ZIPS.put("reviewRating/worstRating/data", "worst-rating");
        ZIPS.put("reviewRating/data", "rating");
        ZIPS.put("pro/data", "pros");
        ZIPS.put("contra/data", "contras");
        ZIPS.put("item-items", "items");
        ZIPS.put("author-reviewer", "reviewer");
        ZIPS.put("datePublished/data", "date-reviewed");
        ZIPS.put("dateVisited/data", "date-visited");
        ZIPS.put("url/href", "url");
        ZIPS.put("url/data", "url");
        ZIPS.put("reviewsUrl/href", "reviewsUrl");
        ZIPS.put("reviewsUrl/data", "reviewsUrl");
        ZIPS.put("description/data", "description");
        ZIPS.put("reviewBody/data", "description");
    }

    @Override
    public Collection<Entity> process(Entity ee) {
        if (ee.getTag().equals("microdata")) {
            BaseMutableEntity e = new BaseMutableEntity(ee,"OrgReviewFromSchema");
            String itemtype = ((StringAttrValue) e.getFirstOrNull("@itemtype")).getContent();
            if ("http://schema.org/Review".equals(itemtype)) {
                //Entity result = new BaseMutableEntity("orgReview",e.getUrl());
//                for (BaseAttrValue attrValue : e.getValues("tag")) {
//                    if (attrValue instanceof EntityAttrValue) {
//                        OrgRatingFromSchemaOrgTagProcessor processor = new OrgRatingFromSchemaOrgTagProcessor();
//                        Collection<Entity> ratings = processor.process(((EntityAttrValue) attrValue).entity);
//                        for (Entity rating : ratings) {
//                            e.appendValue("tag-tags", new EntityAttrValue(rating));
//                        }
//
//                    }
//                }
                ImplProcessProcessor processor;
//                if((e.url).startsWith("http://pravogolosa.net/otzyvcategory")){
//                    System.out.println("Interesting");
//                }
                OrgRatingFromSchemaOrgTagProcessor orgRatingProcessor = new OrgRatingFromSchemaOrgTagProcessor();
                processor = new ImplProcessProcessor(orgRatingProcessor, "tag", "tag-tags");
                if(processor.process(e).iterator().hasNext()){
                    e = (BaseMutableEntity) processor.process(e).iterator().next();
                }
                OrgFromSchema orgFromSchema = new OrgFromSchema();
                processor = new ImplProcessProcessor(orgFromSchema, "itemReviewed", "item-items");
                if(processor.process(e).iterator().hasNext()){
                    e = (BaseMutableEntity) processor.process(e).iterator().next();
                }
                AuthorFromSchema authorFromSchema = new AuthorFromSchema();
                processor = new ImplProcessProcessor(authorFromSchema, "author", "author-reviewer");
                if(processor.process(e).iterator().hasNext()){
                    e = (BaseMutableEntity) processor.process(e).iterator().next();
                }



                ZipperProcessor zipperProcessor = new ZipperProcessor(ZIPS);
                Collection<Entity> results = zipperProcessor.process(e);
                return results;
            }
        }
        return Collections.EMPTY_LIST;
    }

   public static void ExtractOrgFromEntity(BaseMutableEntity e, BaseMutableEntity attrValueEntity) {
        Map<String, String> izips = new HashMap();
        for (BaseAttrValue adrValue : attrValueEntity.getValues("address")) {
            Map<String, String> azips = new HashMap();
            azips.put("streetAddress/data", "street-address");
            azips.put("addressLocality/data", "locality");
            ZipperProcessor adrZipper = new ZipperProcessor(azips);
            Collection<Entity> adrs = adrZipper.process(((EntityAttrValue) adrValue).entity);
            for (Entity adr : adrs) {
                attrValueEntity.appendValue("address-adrs", new EntityAttrValue(adr));
            }
        }
        for (BaseAttrValue geoValue : attrValueEntity.getValues("geo")) {
            Map<String, String> azips = new HashMap();
            azips.put("latitude/data", "latitude");
            azips.put("longitude/data", "longitude");
            ZipperProcessor adrZipper = new ZipperProcessor(azips);
            Collection<Entity> geos = adrZipper.process(((EntityAttrValue) geoValue).entity);
            for (Entity geo : geos) {
                attrValueEntity.appendValue("address-geo", new EntityAttrValue(geo));
            }
        }

        izips.put("email/data", "email");
        izips.put("address/data","adrs");
        izips.put("address-adrs", "adrs");
        izips.put("address-geo", "geo");
        izips.put("telephone/data", "tel");
        izips.put("name/data", "fn");
        izips.put("url/href", "url");
        ZipperProcessor itemZipper = new ZipperProcessor(izips);
        Collection<Entity> items = itemZipper.process(attrValueEntity);
        for (Entity item : items) {
            e.appendValue("item-items", new EntityAttrValue(item));
        }
    }
}
