package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.utils;

import org.json.*;
import ru.yandex.common.util.collections.Cu;
import ru.yandex.common.util.functional.Function;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.BaseAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.BaseMutableEntity;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.*;

import java.util.Iterator;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12.12.13
 * Time: 13:53
 */
public class Json2EntityConvertor {

    private static class ItarableJSONArray implements Iterable {

        final JSONArray array;

        private ItarableJSONArray(final JSONArray array) {
            this.array = array;
        }


        @Override
        public Iterator iterator() {
            return new Iterator() {

                private int pos = 0;

                @Override
                public boolean hasNext() {
                    return pos < array.length();
                }

                @Override
                public Object next() {
                    try {
                        return array.get(pos++);
                    } catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("No remove");
                }
            };
        }
    }

    protected static final Function<Object, BaseAttrValue> JSON_VALUE2ATTR_VALUE = new Function<Object, BaseAttrValue>() {
        @Override
        public BaseAttrValue apply(final Object o) {
            if (o instanceof String) {
                return new StringAttrValue((String) o);
            } else if (o instanceof Long) {
                return new LongAttrValue((Long) o);
            } else if (o instanceof Integer) {
                return new LongAttrValue((Integer) o);
            } else if (o instanceof JSONObject) {
                try {
                    return new EntityAttrValue(fromJson((JSONObject) o));
                } catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException(o.toString());
        }
    };

    public static Entity fromJson(final JSONObject json) throws JSONException {
        final String tag = json.optString("tag");
        final String url = json.optString("url");
        BaseMutableEntity result = new BaseMutableEntity(tag, url);
        JSONObject data = json.getJSONObject("data");
        final Iterator keys = data.keys();
        while (keys.hasNext()) {
            Object key = keys.next();
            final String keyName = (String) key;
            Object val = data.get(keyName);
            if (val instanceof JSONArray) {
                result.setValues(keyName, Cu.map(JSON_VALUE2ATTR_VALUE, new ItarableJSONArray((JSONArray) val)));
            } else {
                result.setValue(keyName, JSON_VALUE2ATTR_VALUE.apply(val));
            }
        }
        return result;
    }

    public static final Function<BaseAttrValue, Object> ATTR_VALUE2JSON_VALUE = new Function<BaseAttrValue, Object>() {
        @Override
        public Object apply(final BaseAttrValue o) {
            if (o instanceof StringAttrValue) {
                return ((StringAttrValue) o).value;
            } else if (o instanceof LongAttrValue) {
                return ((LongAttrValue) o).value;
            } else if (o instanceof EntityAttrValue) {
                try {
                    return toJson(((EntityAttrValue) o).entity);
                } catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException(o.toString());
        }
    };


    public static JSONObject toJson(final Entity entity) throws JSONException {
        final JSONObject result = new JSONObject();
        if (entity.getTag() != null) {
            result.put("tag", entity.getTag());
        }
        final JSONObject data = new JSONObject();
        for (final String key : entity.getAttributes()) {
            final List<BaseAttrValue> vals = entity.getValues(key);
            if (vals.size() == 1) {
                data.put(key, ATTR_VALUE2JSON_VALUE.apply(vals.get(0)));
            } else if (vals.size() > 1) {
                data.put(key, Cu.map(ATTR_VALUE2JSON_VALUE, vals));
            }
        }
        result.put("data", data);
        return result;
    }

}
