package ru.yandex.webmaster3.core.semantic.review_business;

import com.google.common.collect.Iterables;

import java.util.Collection;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

/**
 * Include common utility methods on top of collections
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 25/10/12
 * Time: 11:32 AM
 */
public class Collections {
    private Collections() {
    }

    /**
     * Join collections to new unmodifiable collection.
     * Given collections stays untouched.
     *
     * @param collections collections to be joined
     * @param <T>         type of elements
     * @return new unmodifiable collection that
     *         contains all elements from given collections
     */
    @SuppressWarnings("unchecked")
    public static <T> Collection<T> join(final Collection<T>... collections) {
        return java.util.Collections.unmodifiableCollection(newArrayList(Iterables.concat(collections)));
    }

    /**
     * Join lists to new unmodifiable list.
     * Given lists stays untouched.
     *
     * @param lists lists to be joined
     * @param <T>   type of elements
     * @return new unmodifiable list that
     *         contains all elements from given collections
     */
    @SuppressWarnings("unchecked")
    public static <T> List<T> join(final List<T>... lists) {
        return java.util.Collections.unmodifiableList(newArrayList(Iterables.concat(lists)));
    }
    public static boolean isNullOrEmpty(final Collection<?> c) {
        return (c == null) || c.isEmpty();
    }
}

