package ru.yandex.webmaster3.core.semantic.review_business;

import com.google.common.collect.Iterables;

import java.util.Collection;
import java.util.Date;

import static com.google.common.collect.Lists.newArrayList;

/**
 * Class will include utility methods for manipulating with model classes
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 2/10/12
 * Time: 12:22 PM
 */
public class ModelUtils {
    private ModelUtils() {
    }

    /**
     * Most dates are used with precision to seconds
     */
    public static Date cleanDate(final Date date) {
        long toSeconds = date.getTime() / 1000;
        return new Date(toSeconds * 1000);
    }

    /**
     * Count hashCode value for given object array.
     * Starts with 1 to guarantee that we got different values for arrays of nulls
     * with different size of array.
     */
    public static int hashCode(Object... objects) {
        return hashCodeWithNestedValue(0, objects);
    }

    public static int hashCodeWithNestedValue(int nested, Object... objects) {
        int res = nested;
        for (Object obj : objects) {
            if (obj != null) {
                if (obj instanceof Date) obj = cleanDate((Date) obj);
                if (obj instanceof Collection<?>) obj = newArrayList((Collection<?>) obj);

                res = res * 31 + obj.hashCode();
            }
        }
        return res;
    }

    @SuppressWarnings("unchecked")
    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) return true;
        if (o1 == null || o2 == null) return false;

        if (o1 instanceof Date) {
            return equalsDate((Date) o1, (Date) o2);
        } else if (o1 instanceof Collection) {
            return equalsCollections((Collection) o1, (Collection) o2);
        } else {
            return o1.equals(o2);
        }
    }

    private static boolean equalsDate(Date o1, Date o2) {
        return cleanDate(o1).equals(cleanDate(o2));
    }

    private static <T> boolean equalsCollections(final Collection<T> c1, final Collection<T> c2) {
        return Iterables.elementsEqual(c1, c2);
    }
}
