package ru.yandex.webmaster3.core.semantic.review_business.auto.model;

import ru.yandex.webmaster3.core.semantic.review_business.ModelUtils;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.json.HProductJsonConversions;

/**
 * Represents details of reviewed Car.
 * <p/>
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 24/9/12
 * Time: 5:52 PM
 */
public abstract class HProduct {
    /**
     * Usually returns "auto"
     */
    public String getCategory() {
        return "auto";
    }

    /**
     * Car production year
     */
    public abstract String getProdyear();

    /**
     * Car name
     */
    public abstract String getFn();

    /**
     * Url to car in catalog
     */
    public abstract String getUrl();

    /**
     * Car brand
     */
    public abstract String getBrand();

    /**
     * Identifier for given body type name
     */
    public abstract String getBodyType();

    /**
     * Configuration name for current car model. E.g. "Стандарт 1.6 MT (80 л.с.,бензин)"
     */
    public abstract String getConfName();

    /**
     * Identifier for given conf name
     * From yandex.auto service
     */
    public abstract String getConfCompTechId();

    /**
     * Car engine type
     */
    public abstract String getEngineType();

    /**
     * Car transmission characteristic
     */
    public abstract String getTransmission();

    /**
     * Car gear characteristic
     */
    public abstract String getGearType();

    /**
     * Car steering wheel characteristic
     */
    public abstract String getSteeringWheel();

    /**
     * Car displacement
     */
    public abstract String getDisplacement();

    /**
     * Body type name. Examples: "кроссовер", "седан" etc.
     */
    public abstract String getBodyTypeName();

    /**
     * Car mark
     * Car mark and model are unified version of fn/brand pair
     */
    public abstract String getMark();

    /**
     * Car model
     * Car mark and model are unified version of fn/brand pair
     */
    public abstract String getModel();

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof HProduct)) return false;
        final HProduct hProduct = (HProduct) o;
        return hashCode() == hProduct.hashCode()
                && ModelUtils.equals(getCategory(), hProduct.getCategory())
                && ModelUtils.equals(getProdyear(), hProduct.getProdyear())
                && ModelUtils.equals(getFn(), hProduct.getFn())
                && ModelUtils.equals(getUrl(), hProduct.getUrl())
                && ModelUtils.equals(getBrand(), hProduct.getBrand())
                && ModelUtils.equals(getBodyType(), hProduct.getBodyType())
                && ModelUtils.equals(getConfName(), hProduct.getConfName())
                && ModelUtils.equals(getConfCompTechId(), hProduct.getConfCompTechId())
                && ModelUtils.equals(getEngineType(), hProduct.getEngineType())
                && ModelUtils.equals(getTransmission(), hProduct.getTransmission())
                && ModelUtils.equals(getGearType(), hProduct.getGearType())
                && ModelUtils.equals(getSteeringWheel(), hProduct.getSteeringWheel())
                && ModelUtils.equals(getDisplacement(), hProduct.getDisplacement())
                && ModelUtils.equals(getBodyTypeName(), hProduct.getBodyTypeName())
                && ModelUtils.equals(getMark(), hProduct.getMark())
                && ModelUtils.equals(getModel(), hProduct.getModel());
    }

    @Override
    public int hashCode() {
        return ModelUtils.hashCode(
                getCategory()
                , getProdyear()
                , getFn()
                , getUrl()
                , getBrand()
                , getBodyType()
                , getConfName()
                , getConfCompTechId()
                , getEngineType()
                , getTransmission()
                , getGearType()
                , getSteeringWheel()
                , getDisplacement()
                , getBodyTypeName()
                , getMark()
                , getModel()
        );
    }


    @Override
    public String toString() {
        return HProductJsonConversions.safeToJsonString(this);
    }
}
