package ru.yandex.webmaster3.core.semantic.review_business.auto.model.agg;

import ru.yandex.webmaster3.core.semantic.review_business.ModelUtils;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.BaseAutoReview;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.agg.impl.json.AggAutoReviewJsonConversions;

import java.util.Collection;

/**
 * Represent Auto review from partner.
 * Collected by robots
 * <p/>
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 24/9/12
 * Time: 3:06 PM
 */
public abstract class AggAutoReview extends BaseAutoReview {
    /**
     * Type of the review.
     * For auto reviews it always should be "product"
     *
     * @return "product"
     */
    public String getType() {
        return "product";
    }

    /**
     * @return URL of the page that contains review
     */
    public abstract String getUrl();

    /**
     * Collection of links to feeds with reviews for current car type
     */
    public abstract Collection<String> getReviewsUrl();

    /**
     * Identity of the source-origin of review.
     * This ID assigned to every review that has been added to the system.
     * TODO this is domain-id
     *
     * @return source ID from the system
     */
    public abstract Long getSourceId();

    /**
     * @return domain name of source
     */
    public abstract String getDomain();

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof AggAutoReview)) return false;
        if (!super.equals(o)) return false;

        final AggAutoReview review = (AggAutoReview) o;


        return hashCode() == review.hashCode()
                && ModelUtils.equals(getUrl(), review.getUrl())
                && ModelUtils.equals(getReviewsUrl(), review.getReviewsUrl())
                && ModelUtils.equals(getSourceId(), review.getSourceId())
                && ModelUtils.equals(getDomain(), review.getDomain())
                ;
    }

    @Override
    public int hashCode() {
        return ModelUtils.hashCodeWithNestedValue(
                super.hashCode()
                , getUrl()
                , getReviewsUrl()
                , getSourceId()
                , getDomain()
        );
    }

    /**
     * Construct string representation of AggAutoReview.
     */
    @Override
    public String toString() {
        return AggAutoReviewJsonConversions.toJsonString(this);
    }

}
