package ru.yandex.webmaster3.core.semantic.review_business.auto.model.agg.impl.json;

import org.apache.commons.collections.CollectionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.agg.AggAutoReview;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.json.BaseAutoReviewJsonConversions;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static ru.yandex.webmaster3.core.semantic.review_business.auto.model.agg.impl.AggAutoReviewAttributes.*;

/**
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 5/10/12
 * Time: 1:41 PM
 */
public class AggAutoReviewJsonConversions {
    private AggAutoReviewJsonConversions() {
    }

    static AggAutoReview fromJson(final JSONObject json) {
        return new AggAutoReviewOverJson(json);
    }

    public static AggAutoReview fromJson(final String json) throws JSONException {
        return new AggAutoReviewOverJson(json);
    }

    public static List<AggAutoReview> fromJsonArray(final String json) throws JSONException {
        final List<AggAutoReview> result = newArrayList();
        final JSONArray array = new JSONArray(json);
        for (int i = 0; i < array.length(); i++) {
            result.add(fromJson(array.getJSONObject(i)));
        }
        return result;
    }

    static JSONObject toJson(final AggAutoReview review) {
        try {
            return BaseAutoReviewJsonConversions.toJson(review).
                    putOpt(SOURCE_ID, review.getSourceId()).
                    putOpt(DOMAIN, review.getDomain()).
                    putOpt(URL, review.getUrl()).
                    putOpt(REVIEWSURL, CollectionUtils.isNotEmpty(review.getReviewsUrl()) ?
                            new JSONArray(review.getReviewsUrl()) :
                            null);
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(final AggAutoReview review) {
        return toJson(review).toString();
    }

    public static String toJsonString(final AggAutoReview review, final int indentFactor) {
        try {
            return toJson(review).toString(indentFactor);
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}
