package ru.yandex.webmaster3.core.semantic.review_business.auto.model.agg.impl.json;


import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.*;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.agg.AggAutoReview;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.json.BaseAutoReviewOverJson;
import ru.yandex.webmaster3.core.semantic.review_business.model.Author;
import ru.yandex.webmaster3.core.semantic.review_business.util.JsonAccessUtils;

import java.util.*;

import static com.google.common.base.Strings.emptyToNull;
import static ru.yandex.webmaster3.core.semantic.review_business.auto.model.agg.impl.AggAutoReviewAttributes.*;

/**
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 5/10/12
 * Time: 12:14 PM
 */
@Slf4j
public class AggAutoReviewOverJson extends AggAutoReview {
    private final JSONObject json;
    private final BaseAutoReview review;

    AggAutoReviewOverJson(JSONObject json) {
        Preconditions.checkNotNull(json, "Unable to create AggAutoReview over null JSON");

        review = new BaseAutoReviewOverJsonWithSharedDelegate(json);
        this.json = json;
    }

    public AggAutoReviewOverJson(String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create AggAutoReview over empty JSON string");

        this.json = new JSONObject(json);
        review = new BaseAutoReviewOverJsonWithSharedDelegate(this.json);
    }

    @Override
    public Collection<String> getReviewsUrl() {
        try {
            return JsonAccessUtils.arrayToStrings(json.optJSONArray(REVIEWSURL));
        } catch (JSONException e) {
            log.error("Error while getting reviews url", e);
            return Collections.emptyList();
        }

    }

    @Override
    public String getLanguage() {
        return review.getLanguage();
    }

    @Override
    public String getId() {
        return review.getId();
    }

    @Override
    public String getPermanentId() {
        return review.getPermanentId();
    }

    @Override
    public String getVersionId() {
        return review.getVersionId();
    }

    @Override
    public Float getRating() {
        return review.getRating();
    }

    @Override
    public Float getBestRating() {
        return review.getBestRating();
    }

    @Override
    public Float getWorstRating() {
        return review.getWorstRating();
    }

    @Override
    public Float getNormalizedRating() {
        return review.getNormalizedRating();
    }

    @Override
    public Author getReviewer() {
        return review.getReviewer();
    }

    @Override
    public Date getReviewedDate() {
        return review.getReviewedDate();
    }

    @Override
    public String getUrl() {
        return json.optString(URL, null);
    }

    @Override
    public String getDescription() {
        return review.getDescription();
    }

    @Override
    public String getSummary() {
        return review.getSummary();
    }

    @Override
    public Date getWatchTime() {
        return review.getWatchTime();
    }

    @Override
    public HProduct getItem() {
        return review.getItem();
    }

    @Override
    public Collection<String> getPhotos() {
        return review.getPhotos();
    }

    @Override
    public Long getSourceId() {
        return JsonAccessUtils.optLong(json, SOURCE_ID);
    }

    @Override
    public String getDomain() {
        return json.optString(DOMAIN, null);
    }

    @Override
    public Collection<String> getPros() {
        return review.getPros();
    }

    @Override
    public Collection<String> getContras() {
        return review.getContras();
    }

    @Override
    public List<AutoModeration> getModerationHistory() {
        return review.getModerationHistory();
    }

    @Override
    public boolean isDeleted() {
        return review.isDeleted();
    }

    @Override
    public Integer getUsefulCount() {
        return review.getUsefulCount();
    }

    @Override
    public Integer getUselessCount() {
        return review.getUselessCount();
    }

    @Override
    public List<String> getPhotoUrls() {
        return review.getPhotoUrls();
    }

    /**
     * Inner child of BaseAutoReviewOverJson to get access to contructor with JSONObject argument
     */
    private static final class BaseAutoReviewOverJsonWithSharedDelegate extends BaseAutoReviewOverJson {
        BaseAutoReviewOverJsonWithSharedDelegate(JSONObject json) {
            super(json);
        }
    }
}
