package ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.AutoModeration;
import ru.yandex.webmaster3.core.semantic.review_business.model.impl.ReviewModerationAttributes;
import ru.yandex.webmaster3.core.semantic.review_business.util.DateHelper;

import java.util.Date;

import static com.google.common.base.Strings.emptyToNull;

/**
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 28/9/12
 * Time: 3:38 PM
 */
public class AutoModerationOverJson extends AutoModeration {
    private final JSONObject json;

    AutoModerationOverJson(JSONObject json) {
        Preconditions.checkNotNull(json, "Unable to create AutoModeration over null JSON");

        this.json = json;
    }

    public AutoModerationOverJson(String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create AutoModeration over empty JSON string");
        this.json = new JSONObject(json);
    }

    @Override
    public RejReason getRejReason() {
        return RejReason.safeValueOf(json.optString(ReviewModerationAttributes.REJECTION_REASON, null));
    }

    @Override
    public Status getStatus() {
        return Status.safeValueOf(json.optString(ReviewModerationAttributes.STATUS, null));
    }

    @Override
    public String getCustomRejectionText() {
        return json.optString(ReviewModerationAttributes.CUSTOM_REJECTION_TEXT, null);
    }

    @Override
    public Handler getHandler() {
        return Handler.safeValueOf(json.optString(ReviewModerationAttributes.HANDLER, null));
    }

    @Override
    public Date getTime() {
        return DateHelper.read(json.optString(ReviewModerationAttributes.TIME, null));
    }

    @Override
    public String getNote() {
        return json.optString(ReviewModerationAttributes.NOTE, null);
    }

    @Override
    public String getRejectionText() {
        return json.optString(ReviewModerationAttributes.REJECTION_TEXT, null);
    }
}
