package ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.json;

import com.google.common.collect.Lists;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.BaseAutoReview;
import ru.yandex.webmaster3.core.semantic.review_business.model.impl.json.AuthorJsonConversions;
import ru.yandex.webmaster3.core.semantic.review_business.util.DateHelper;

import static com.google.common.collect.Iterables.isEmpty;
import static ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.BaseAutoReviewAttributes.*;
import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.HCardAttributes.PHOTO;

/**
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 5/10/12
 * Time: 2:47 PM
 */
public class BaseAutoReviewJsonConversions {
    private BaseAutoReviewJsonConversions() {
    }

    public static JSONObject toJson(final BaseAutoReview review) {
        try {
            return new JSONObject().
                    putOpt(ID, review.getId()).
                    putOpt(LANGUAGE, review.getLanguage()).
                    putOpt(RATING, review.getRating()).
                    putOpt(BEST_RATING, review.getBestRating()).
                    putOpt(WORST_RATING, review.getWorstRating()).
                    putOpt(DESCRIPTION, review.getDescription()).
                    putOpt(REVIEWER,
                            review.getReviewer() == null ? null : AuthorJsonConversions.toJson(review.getReviewer())).
                    putOpt(REVIEWED_DATE,
                            review.getReviewedDate() == null ? null : DateHelper.write(review.getReviewedDate())).
                    putOpt(PERMANENT_ID, review.getPermanentId()).
                    putOpt(VERSION_ID, review.getVersionId()).
                    putOpt(ITEM, review.getItem() == null ? null : HProductJsonConversions.toJson(review.getItem())).
                    putOpt(PHOTO, isEmpty(review.getPhotos()) ? null : new JSONArray(review.getPhotos())).
                    putOpt(PRO, isEmpty(review.getPros()) ? null : new JSONArray(review.getPros())).
                    putOpt(CONTRA, isEmpty(review.getContras()) ? null : new JSONArray(review.getContras())).
                    putOpt(SUMMARY, review.getSummary()).
                    putOpt(WATCH_TIME, review.getWatchTime() == null ? null : DateHelper.write(review.getWatchTime())).
                    putOpt(MODERATION_HISTORY, review.hasModeration() ? new JSONArray(
                            Lists.transform(review.getModerationHistory(),
                                    AutoModerationJsonConversions.MODERATION_TO_JSON)) : null).
                    putOpt(DELETED, review.isDeleted() ? Boolean.TRUE : null).
                    putOpt(USEFUL, review.getUsefulCount()).
                    putOpt(USELESS, review.getUselessCount()).
                    putOpt(PHOTO_URLS, isEmpty(review.getPhotoUrls()) ? null : new JSONArray(review.getPhotoUrls()));
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}
