package ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.HProduct;

import static com.google.common.base.Strings.emptyToNull;
import static ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.HProductAttributes.*;

/**
 * @author: ishalaru
 * DATE: 14.10.2019
 */
public class HProductOverJson extends HProduct {
    private final JSONObject json;

    HProductOverJson(JSONObject json) {
        Preconditions.checkNotNull(json, "Unable to create HProduct over null JSON");

        this.json = json;
    }

    public HProductOverJson(String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create HProduct over empty JSON string");
        this.json = new JSONObject(json);
    }

    @Override
    public String getProdyear() {
        return json.optString(PRODYEAR, null);
    }

    @Override
    public String getFn() {
        return json.optString(FN, null);
    }

    @Override
    public String getUrl() {
        return json.optString(URL, null);
    }

    @Override
    public String getBrand() {
        return json.optString(BRAND, null);
    }

    @Override
    public String getBodyType() {
        return json.optString(BODY_TYPE, null);
    }

    @Override
    public String getConfName() {
        return json.optString(CONF_NAME, null);
    }

    @Override
    public String getConfCompTechId() {
        return json.optString(CONF_COMP_TECH_ID, null);
    }

    @Override
    public String getEngineType() {
        return json.optString(ENGINE_TYPE, null);
    }

    @Override
    public String getTransmission() {
        return json.optString(TRANSMISSION, null);
    }

    @Override
    public String getGearType() {
        return json.optString(GEAR_TYPE, null);
    }

    @Override
    public String getSteeringWheel() {
        return json.optString(STEERING_WHEEL, null);
    }

    @Override
    public String getDisplacement() {
        return json.optString(DISPLACEMENT, null);
    }

    @Override
    public String getBodyTypeName() {
        return json.optString(BODY_TYPE_NAME, null);
    }

    @Override
    public String getMark() {
        return json.optString(MARK, null);
    }

    @Override
    public String getModel() {
        return json.optString(MODEL, null);
    }
}
