package ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.wrapper;

import ru.yandex.webmaster3.core.semantic.review_business.auto.model.AutoModeration;
import ru.yandex.webmaster3.core.semantic.review_business.model.ReviewModeration;
import ru.yandex.webmaster3.core.semantic.review_business.model.impl.wrapper.ReviewModerationWrapper;

import java.util.Date;

/**
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 5/10/12
 * Time: 4:38 PM
 */
public class AutoModerationWrapper extends AutoModeration {
    public static AutoModerationWrapper newModeration() {
        return EMPTY_WRAPPER;
    }

    private final AutoModeration moderation;
    private final ReviewModerationWrapper baseModeration;

    public AutoModerationWrapper(final AutoModeration moderation) {
        this(moderation, new ReviewModerationBase(moderation));
    }

    private AutoModerationWrapper(final AutoModeration moderation, final ReviewModerationWrapper baseModeration) {
        if (moderation == null)
            throw new NullPointerException("Unable to wrap null AutoModeration");
        this.moderation = moderation;
        this.baseModeration = baseModeration;
    }

    @Override
    public RejReason getRejReason() {
        return moderation.getRejReason();
    }

    public AutoModerationWrapper setRejectionReason(final AutoModeration.RejReason reason) {
        return new AutoModerationWrapper(this) {
            @Override
            public RejReason getRejReason() {
                return reason;
            }
        };
    }

    @Override
    public Status getStatus() {
        return baseModeration.getStatus();
    }

    public AutoModerationWrapper setStatus(final ReviewModeration.Status status) {
        return wrapBaseReview(baseModeration.setStatus(status));
    }

    @Override
    public String getCustomRejectionText() {
        return baseModeration.getCustomRejectionText();
    }

    public AutoModerationWrapper setCustomRejectionText(final String text) {
        return wrapBaseReview(baseModeration.setCustomRejectionText(text));
    }

    @Override
    public Handler getHandler() {
        return baseModeration.getHandler();
    }

    public AutoModerationWrapper setHandler(final ReviewModeration.Handler handler) {
        return wrapBaseReview(baseModeration.setHandler(handler));
    }

    @Override
    public Date getTime() {
        return baseModeration.getTime();
    }

    public AutoModerationWrapper setTime(final Date time) {
        return wrapBaseReview(baseModeration.setTime(time));
    }

    @Override
    public String getNote() {
        return baseModeration.getNote();
    }

    public AutoModerationWrapper setNote(final String note) {
        return wrapBaseReview(baseModeration.setNote(note));
    }
    @Override
    public String getRejectionText() {
        return baseModeration.getRejectionText();
    }

    public AutoModerationWrapper setRejectionText(final String rejectionText) {
        return wrapBaseReview(baseModeration.setRejectionText(rejectionText));
    }

    private AutoModerationWrapper wrapBaseReview(final ReviewModerationWrapper baseModeration) {
        return new AutoModerationWrapper(this, baseModeration);
    }

    private static final AutoModerationWrapper EMPTY_WRAPPER = new AutoModerationWrapper(
            new AutoModeration() {
                @Override
                public Status getStatus() {
                    return null;
                }

                @Override
                public RejReason getRejReason() {
                    return null;
                }

                @Override
                public String getCustomRejectionText() {
                    return null;
                }

                @Override
                public Handler getHandler() {
                    return null;
                }

                @Override
                public Date getTime() {
                    return null;
                }

                @Override
                public String getNote() {
                    return null;
                }

                @Override
                public String getRejectionText() {
                    return null;
                }
            });

    private static class ReviewModerationBase extends ReviewModerationWrapper {
        private ReviewModerationBase(ReviewModeration moderation) {
            super(moderation);
        }
    }
}

