package ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.wrapper;

import com.google.common.base.Preconditions;
import ru.yandex.webmaster3.core.semantic.review_business.Collections;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.*;
import ru.yandex.webmaster3.core.semantic.review_business.model.Author;

import java.util.*;

import static java.util.Arrays.asList;

/**
 * Represents common part of auto review
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 25/10/12
 * Time: 10:26 AM
 */
public class BaseAutoReviewWrapper extends BaseAutoReview {
    private final BaseAutoReview review;

    public static BaseAutoReviewWrapper newBaseReview() {
        return EMPTY_AGG_AUTO_REVIEW_WRAPPER;
    }

    public BaseAutoReviewWrapper(final BaseAutoReview review) {
        Preconditions.checkNotNull(review, "Unable to wrap null BaseAutoReview!");

        this.review = review;
    }

    @Override
    public String getLanguage() {
        return review.getLanguage();
    }

    public BaseAutoReviewWrapper setLanguage(final String language) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public String getLanguage() {
                return language;
            }
        };
    }

    @Override
    public String getSummary() {
        return review.getSummary();
    }

    public BaseAutoReviewWrapper setSummary(final String summary) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public String getSummary() {
                return summary;
            }
        };
    }

    @Override
    public Date getWatchTime() {
        return review.getWatchTime();
    }

    public BaseAutoReviewWrapper setWatchTime(final Date watchTime) {
        final Date result = watchTime == null ? null : new Date(watchTime.getTime());

        return new BaseAutoReviewWrapper(this) {
            @Override
            public Date getWatchTime() {
                return result;
            }
        };
    }

    @Override
    public HProduct getItem() {
        return review.getItem();
    }

    public BaseAutoReviewWrapper setItem(final HProduct item) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public HProduct getItem() {
                return item;
            }
        };
    }

    @Override
    public Collection<String> getPhotos() {
        return review.getPhotos();
    }

    public BaseAutoReviewWrapper addPhotos(final String... photos) {
        return addPros(asList(photos));
    }

    @SuppressWarnings("unchecked")
    public BaseAutoReviewWrapper addPhotos(final Collection<String> photos) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Collection<String> getPhotos() {
                return Collections.join(super.getPhotos(), photos);
            }
        };
    }

    public BaseAutoReviewWrapper setPhotos(final String... photos) {
        return setPhotos(asList(photos));
    }

    public BaseAutoReviewWrapper setPhotos(final Collection<String> photos) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Collection<String> getPhotos() {
                return java.util.Collections.unmodifiableCollection(photos);
            }
        };
    }

    @Override
    public Collection<String> getPros() {
        return review.getPros();
    }

    public BaseAutoReviewWrapper addPros(final String... pros) {
        return addPros(asList(pros));
    }

    @SuppressWarnings("unchecked")
    public BaseAutoReviewWrapper addPros(final Collection<String> pros) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Collection<String> getPros() {
                return Collections.join(super.getPros(), pros);
            }
        };
    }

    public BaseAutoReviewWrapper setPros(final String... pros) {
        return setPros(asList(pros));
    }

    public BaseAutoReviewWrapper setPros(final Collection<String> pros) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Collection<String> getPros() {
                return java.util.Collections.unmodifiableCollection(pros);
            }
        };
    }

    @Override
    public Collection<String> getContras() {
        return review.getContras();
    }

    public BaseAutoReviewWrapper addContras(final String... contras) {
        return addContras(asList(contras));
    }

    @SuppressWarnings("unchecked")
    public BaseAutoReviewWrapper addContras(final Collection<String> contras) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Collection<String> getContras() {
                return Collections.join(super.getContras(), contras);
            }
        };
    }

    public BaseAutoReviewWrapper setContras(final String... contras) {
        return setContras(asList(contras));
    }

    public BaseAutoReviewWrapper setContras(final Collection<String> contras) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Collection<String> getContras() {
                return java.util.Collections.unmodifiableCollection(contras);
            }
        };
    }

    @Override
    public String getId() {
        return review.getId();
    }

    public BaseAutoReviewWrapper setId(final String id) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public String getId() {
                return id;
            }
        };
    }

    @Override
    public Float getRating() {
        return review.getRating();
    }

    public BaseAutoReviewWrapper setRating(final Float rating) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Float getRating() {
                return rating;
            }
        };
    }


    @Override
    public Float getBestRating() {
        return review.getBestRating();
    }

    public BaseAutoReviewWrapper setBestRating(final float bestRating) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Float getBestRating() {
                return bestRating;
            }
        };
    }

    @Override
    public Float getWorstRating() {
        return review.getWorstRating();
    }

    public BaseAutoReviewWrapper setWorstRating(final float worstRating) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Float getWorstRating() {
                return worstRating;
            }
        };
    }

    @Override
    public Author getReviewer() {
        return review.getReviewer();
    }

    public BaseAutoReviewWrapper setReviewer(final Author reviewer) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Author getReviewer() {
                return reviewer;
            }
        };
    }


    @Override
    public Date getReviewedDate() {
        return review.getReviewedDate();
    }

    public BaseAutoReviewWrapper setReviewedDate(final Date reviewedDate) {
        final Date result = reviewedDate == null ? null : new Date(reviewedDate.getTime());

        return new BaseAutoReviewWrapper(this) {
            @Override
            public Date getReviewedDate() {
                return result;
            }
        };
    }

    @Override
    public String getPermanentId() {
        return review.getPermanentId();
    }

    public BaseAutoReviewWrapper setPermanentId(final String permanentId) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public String getPermanentId() {
                return permanentId;
            }
        };
    }

    @Override
    public String getVersionId() {
        return review.getVersionId();
    }

    public BaseAutoReviewWrapper setVersionId(final String versionId) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public String getVersionId() {
                return versionId;
            }
        };
    }


    @Override
    public String getDescription() {
        return review.getDescription();
    }

    public BaseAutoReviewWrapper setDescription(final String description) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public String getDescription() {
                return description;
            }
        };
    }

    @Override
    public List<AutoModeration> getModerationHistory() {
        return review.getModerationHistory();
    }

    public BaseAutoReviewWrapper setModerationHistory(final List<AutoModeration> history) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public List<AutoModeration> getModerationHistory() {
                return java.util.Collections.unmodifiableList(history);
            }
        };
    }

    public BaseAutoReviewWrapper setModerationHistory(final AutoModeration... history) {
        return setModerationHistory(asList(history));
    }

    public BaseAutoReviewWrapper addModerationHistory(final List<AutoModeration> history) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public List<AutoModeration> getModerationHistory() {
                return Collections.join(super.getModerationHistory(), history);
            }
        };
    }

    public BaseAutoReviewWrapper addModerationHistory(final AutoModeration... history) {
        return addModerationHistory(asList(history));
    }

    @Override
    public boolean isDeleted() {
        return review.isDeleted();
    }

    public BaseAutoReviewWrapper setDeleted(final boolean isDeleted) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public boolean isDeleted() {
                return isDeleted;
            }
        };
    }

    @Override
    public Integer getUsefulCount() {
        return review.getUsefulCount();
    }

    public BaseAutoReviewWrapper setUsefulCount(final Integer usefulCount) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Integer getUsefulCount() {
                return usefulCount;
            }
        };
    }

    @Override
    public Integer getUselessCount() {
        return review.getUselessCount();
    }

    public BaseAutoReviewWrapper setUselessCount(final Integer uselessCount) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public Integer getUselessCount() {
                return uselessCount;
            }
        };
    }

    @Override
    public List<String> getPhotoUrls() {
        return review.getPhotoUrls();
    }

    public BaseAutoReviewWrapper setPhotoUrls(final List<String> photoUrls) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public List<String> getPhotoUrls() {
                return java.util.Collections.unmodifiableList(photoUrls);
            }
        };
    }
    public BaseAutoReviewWrapper setPhotoUrls(final String... photoUrls) {
        return setPhotoUrls(Arrays.asList(photoUrls));
    }

    @SuppressWarnings("unchecked")
    public BaseAutoReviewWrapper addPhotoUrls(final List<String> photoUrls) {
        return new BaseAutoReviewWrapper(this) {
            @Override
            public List<String> getPhotoUrls() {
                return Collections.join(super.getPhotoUrls(), photoUrls);
            }
        };
    }


    private final static BaseAutoReviewWrapper EMPTY_AGG_AUTO_REVIEW_WRAPPER =
            new BaseAutoReviewWrapper(new BaseAutoReview() {
                @Override
                public String getLanguage() {
                    return null;
                }

                @Override
                public String getSummary() {
                    return null;
                }

                @Override
                public Date getWatchTime() {
                    return null;
                }

                @Override
                public HProduct getItem() {
                    return null;
                }

                @Override
                public Collection<String> getPhotos() {
                    return java.util.Collections.emptyList();
                }

                @Override
                public Collection<String> getPros() {
                    return java.util.Collections.emptyList();
                }

                @Override
                public Collection<String> getContras() {
                    return java.util.Collections.emptyList();
                }

                @Override
                public String getId() {
                    return null;
                }

                @Override
                public Float getRating() {
                    return null;
                }

                @Override
                public Float getBestRating() {
                    return null;
                }

                @Override
                public Float getWorstRating() {
                    return null;
                }

                @Override
                public Author getReviewer() {
                    return null;
                }

                @Override
                public Date getReviewedDate() {
                    return null;
                }

                @Override
                public String getPermanentId() {
                    return null;
                }

                @Override
                public String getVersionId() {
                    return null;
                }

                @Override
                public String getDescription() {
                    return null;
                }

                @Override
                public List<AutoModeration> getModerationHistory() {
                    return java.util.Collections.emptyList();
                }

                @Override
                public boolean isDeleted() {
                    return false;
                }

                @Override
                public Integer getUsefulCount() {
                    return null;
                }

                @Override
                public Integer getUselessCount() {
                    return null;
                }

                @Override
                public List<String> getPhotoUrls() {
                    return java.util.Collections.emptyList();
                }
            });
}
