package ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.wrapper;

import com.google.common.base.Preconditions;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.HProduct;

/**
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 24/9/12
 * Time: 6:31 PM
 */
public class HProductWrapper extends HProduct {
    private final HProduct hProduct;

    public static HProductWrapper newHProduct() {
        return EMPTY_HPRODUCT_WRAPPER;
    }

    public HProductWrapper(HProduct hProduct) {
        Preconditions.checkNotNull(hProduct, "Unable to wrap null hProduct!");

        this.hProduct = hProduct;
    }

    @Override
    public String getProdyear() {
        return hProduct.getProdyear();
    }

    public HProductWrapper setProdyear(final String prodyear) {
        return new HProductWrapper(this) {
            @Override
            public String getProdyear() {
                return prodyear;
            }
        };
    }

    @Override
    public String getFn() {
        return hProduct.getFn();
    }

    public HProductWrapper setFn(final String fn) {
        return new HProductWrapper(this) {
            @Override
            public String getFn() {
                return fn;
            }
        };
    }

    @Override
    public String getUrl() {
        return hProduct.getUrl();
    }

    public HProductWrapper setUrl(final String url) {
        return new HProductWrapper(this) {
            @Override
            public String getUrl() {
                return url;
            }
        };
    }

    @Override
    public String getBrand() {
        return hProduct.getBrand();
    }

    public HProductWrapper setBrand(final String brand) {
        return new HProductWrapper(this) {
            @Override
            public String getBrand() {
                return brand;
            }
        };
    }

    @Override
    public String getBodyType() {
        return hProduct.getBodyType();
    }

    public HProductWrapper setBodyType(final String bodyType) {
        return new HProductWrapper(this) {
            @Override
            public String getBodyType() {
                return bodyType;
            }
        };
    }

    @Override
    public String getConfName() {
        return hProduct.getConfName();
    }

    public HProductWrapper setConfName(final String confName) {
        return new HProductWrapper(this) {
            @Override
            public String getConfName() {
                return confName;
            }
        };
    }

    @Override
    public String getConfCompTechId() {
        return hProduct.getConfCompTechId();
    }

    public HProductWrapper setConfCompTechId(final String confCompTechId) {
        return new HProductWrapper(this) {
            @Override
            public String getConfCompTechId() {
                return confCompTechId;
            }
        };
    }

    @Override
    public String getEngineType() {
        return hProduct.getEngineType();
    }

    public HProductWrapper setEngineType(final String engineType) {
        return new HProductWrapper(this) {
            @Override
            public String getEngineType() {
                return engineType;
            }
        };
    }

    @Override
    public String getTransmission() {
        return hProduct.getTransmission();
    }

    public HProductWrapper setTransmission(final String transmission) {
        return new HProductWrapper(this) {
            @Override
            public String getTransmission() {
                return transmission;
            }
        };
    }

    @Override
    public String getGearType() {
        return hProduct.getGearType();
    }

    public HProductWrapper setGearType(final String gearType) {
        return new HProductWrapper(this) {
            @Override
            public String getGearType() {
                return gearType;
            }
        };
    }

    @Override
    public String getSteeringWheel() {
        return hProduct.getSteeringWheel();
    }

    public HProductWrapper setSteeringWheel(final String steeringWheel) {
        return new HProductWrapper(this) {
            @Override
            public String getSteeringWheel() {
                return steeringWheel;
            }
        };
    }

    @Override
    public String getDisplacement() {
        return hProduct.getDisplacement();
    }

    public HProductWrapper setDisplacement(final String displacement) {
        return new HProductWrapper(this) {
            @Override
            public String getDisplacement() {
                return displacement;
            }
        };
    }

    @Override
    public String getBodyTypeName() {
        return hProduct.getBodyTypeName();
    }

    public HProductWrapper setBodyTypeName(final String bodyTypeName) {
        return new HProductWrapper(this) {
            @Override
            public String getBodyTypeName() {
                return bodyTypeName;
            }
        };
    }

    @Override
    public String getMark() {
        return hProduct.getMark();
    }

    public HProductWrapper setMark(final String mark) {
        return new HProductWrapper(this) {
            @Override
            public String getMark() {
                return mark;
            }
        };
    }

    @Override
    public String getModel() {
        return hProduct.getModel();
    }

    public HProductWrapper setModel(final String model) {
        return new HProductWrapper(this) {
            @Override
            public String getModel() {
                return model;
            }
        };
    }

    private static final HProductWrapper EMPTY_HPRODUCT_WRAPPER = new HProductWrapper(
            new HProduct() {
                @Override
                public String getProdyear() {
                    return null;
                }

                @Override
                public String getFn() {
                    return null;
                }

                @Override
                public String getUrl() {
                    return null;
                }

                @Override
                public String getBrand() {
                    return null;
                }

                @Override
                public String getBodyType() {
                    return null;
                }

                @Override
                public String getConfName() {
                    return null;
                }

                @Override
                public String getConfCompTechId() {
                    return null;
                }

                @Override
                public String getEngineType() {
                    return null;
                }

                @Override
                public String getTransmission() {
                    return null;
                }

                @Override
                public String getGearType() {
                    return null;
                }

                @Override
                public String getSteeringWheel() {
                    return null;
                }

                @Override
                public String getDisplacement() {
                    return null;
                }

                @Override
                public String getBodyTypeName() {
                    return null;
                }

                @Override
                public String getMark() {
                    return null;
                }

                @Override
                public String getModel() {
                    return null;
                }
            }
    );
}
