package ru.yandex.webmaster3.core.semantic.review_business.auto.model.ugc.impl.json;

import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.Locales;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.impl.json.BaseAutoReviewJsonConversions;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.ugc.UgcAutoReview;
import ru.yandex.webmaster3.core.semantic.review_business.model.impl.json.UserIdentityJsonConversions;

import static ru.yandex.webmaster3.core.semantic.review_business.auto.model.ugc.impl.UgcAutoReviewAttributes.*;

/**
 * User: Evgeny Zhoga (ezhoga@yandex-team.ru)
 * Date: 15/10/12
 * Time: 7:09 PM
 */
public class UgcAutoReviewJsonConversions {
    private UgcAutoReviewJsonConversions() {
    }

    static UgcAutoReview fromJson(final JSONObject json) {
        return new UgcAutoReviewOverJson(json);
    }

    public static UgcAutoReview fromJson(final String json) {
        try {
            return new UgcAutoReviewOverJson(json);
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static JSONObject toJson(final UgcAutoReview review) {
        try {
            return BaseAutoReviewJsonConversions.toJson(review).
                    putOpt(YUID, review.getUid()).
                    putOpt(CREATED_TIME, review.getCreatedTime()).
                    putOpt(LAST_MODIFICATION_TIME, review.getLastModificationTime()).
                    putOpt(OWNING_TIME, review.getOwningTime()).
                    putOpt(USER_IDENTITY, review.getUserIdentity() == null ?
                            null : UserIdentityJsonConversions.toJson(review.getUserIdentity())).
                    putOpt(PREVIOUS_ID, review.getPreviousId()).
                    putOpt(DOMAIN, review.getDomain()).
                    putOpt(UI_LANGUAGE, Locales.toString(review.getUiLanguage()));
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(final UgcAutoReview review) {
        return toJson(review).toString();
    }
}

