package ru.yandex.webmaster3.core.semantic.review_business.biz.model;

/**
 * Category of the business.
 * Can be used for more precise matching with catalogs.
 * <p/>
 * User: willzyx
 * Date: 8/27/12 - 7:23 PM
 */
public enum BizCategory {
    MATERNITY,
    RESTAURANT,
    HOTEL;

    private final String name;

    private BizCategory() {
        this.name = this.toString().toLowerCase();
    }

    public static BizCategory byName(final String name, final BizCategory defaultValue) {
        for (BizCategory category : values()) {
            if (category.name.equalsIgnoreCase(name)) {
                return category;
            }
        }
        return defaultValue;
    }

    public String getName() {
        return name;
    }
}
