package ru.yandex.webmaster3.core.semantic.review_business.biz.model;

import org.json.JSONException;
import ru.yandex.webmaster3.core.semantic.review_business.ModelUtils;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.BizReviewAttributes;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.HCardAttributes;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.wrapper.BusinessCardWrapper;
import ru.yandex.webmaster3.core.semantic.review_business.model.utilities.ModelWriteException;
import ru.yandex.webmaster3.core.semantic.review_business.model.utilities.json.JsonDataWriter;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * User: Evgeny Zhoga <ezhoga@yandex-team.ru>
 * Date: 13.11.13
 */
public abstract class BusinessCard {
    public static final String BIZ_ID = BizReviewAttributes.BIZ_ID;
    public abstract Long getBizId();

    public static final String SOURCE_ID = BizReviewAttributes.SOURCE_ID;
    public abstract Long getSourceId();

    public static final String URL = HCardAttributes.URL;
    public abstract String getUrl();

    public static final String LOCAL_URL = HCardAttributes.LOCALURL;
    public abstract String getLocalUrl();

    public static final String SNIPPET = "snippet";
    public abstract String getSnippet();

    public static final String WATCH_TIME = BizReviewAttributes.WATCH_TIME;
    public abstract Date getWatchTime();

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof BusinessCard)) return false;

        final BusinessCard businessCard = (BusinessCard) o;

        return hashCode() == businessCard.hashCode()
                && ModelUtils.equals(getBizId(), businessCard.getBizId())
                && ModelUtils.equals(getSourceId(), businessCard.getSourceId())
                && ModelUtils.equals(getUrl(), businessCard.getUrl())
                && ModelUtils.equals(getLocalUrl(), businessCard.getLocalUrl())
                && ModelUtils.equals(getSnippet(), businessCard.getSnippet())
                && ModelUtils.equals(getWatchTime(), businessCard.getWatchTime())
                ;
    }

    @Override
    public int hashCode() {
        return ModelUtils.hashCode(
                getBizId()
                ,getSourceId()
                ,getUrl()
                ,getLocalUrl()
                ,getSnippet()
                ,getWatchTime()
        );
    }

    @Override
    public String toString() {
        try {
            JsonDataWriter writer = new JsonDataWriter();
            BusinessCardWrapper.write(writer, this);
            return writer.get().toString(1);
        } catch (ModelWriteException e) {
            throw new AssertionError("Not expected to be thrown");
        } catch (JSONException e) {
            throw new AssertionError("Not expected to be thrown");
        }
    }
}

