package ru.yandex.webmaster3.core.semantic.review_business.biz.model;

import org.json.JSONException;
import ru.yandex.webmaster3.core.semantic.review_business.ModelUtils;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json.CommentJsonConversions;

import java.util.Date;

/**
 * Comment on review from biz.
 * <p/>
 * Getters of this class are used to count hashCode, so to keep contract (see first point in {@link Object#hashCode()})
 * they should return objects which have same hashCode value during application run time
 * In general - implementation should be immutable and return references which are also immutable
 * <p/>
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public abstract class Comment {
    /**
     * @return text of this comment
     */
    public abstract String getText();

    /**
     * @return comment publication time
     */
    public abstract Date getPublishedDate();

    /**
     * @return ID of biz that create comment
     */
    public abstract Long getBizId();

    /**
     * @return ID of review on which comment is
     */
    public abstract String getReviewId();

    /**
     * @return UID of review's author on which comment is
     */
    public abstract Long getReviewAuthorUid();

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof Comment)) return false;

        final Comment comment = (Comment) o;

        return hashCode() == comment.hashCode()
                && ModelUtils.equals(getText(), comment.getText())
                && ModelUtils.equals(getPublishedDate(), comment.getPublishedDate())
                && ModelUtils.equals(getBizId(), comment.getBizId())
                && ModelUtils.equals(getReviewId(), comment.getReviewId())
                && ModelUtils.equals(getReviewAuthorUid(), comment.getReviewAuthorUid());
    }

    @Override
    public int hashCode() {
        return ModelUtils.hashCode(
                getText()
                ,getPublishedDate()
                ,getBizId()
                ,getReviewId()
                ,getReviewAuthorUid()
        );
    }

    @Override
    public String toString() {
        try {
            return CommentJsonConversions.toJson(this).toString(1);
        } catch (JSONException e) {
            throw new AssertionError("Not expected to be thrown");
        }
    }
}

