package ru.yandex.webmaster3.core.semantic.review_business.biz.model;

import org.json.JSONException;
import ru.yandex.webmaster3.core.semantic.review_business.ModelUtils;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json.FeatureJsonConversions;

/**
 * Feature of business.
 * It may be "wi-fi availability" for cafe
 * or "around-the-clock work" for shop.
 * <p/>
 * Getters of this class are used to count hashCode, so to keep contract (see first point in {@link Object#hashCode()})
 * they should return objects which have same hashCode value during application run time
 * In general - implementation should be immutable and return references which are also immutable
 * <p/>
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public abstract class Feature {
    /**
     * @return Name of the future. Null signals for off-design state.
     */
    public abstract String getName();

    /**
     * @return Value of the future. Null signals for off-design state.
     */
    public abstract String getValue();

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof Feature)) return false;

        final Feature feature = (Feature) o;

        return hashCode() == feature.hashCode()
                && ModelUtils.equals(getName(), feature.getName())
                && ModelUtils.equals(getValue(), feature.getValue());
    }

    @Override
    public int hashCode() {
        return ModelUtils.hashCode(
                getName()
                ,getValue()
        );
    }

    @Override
    public String toString() {
        try {
            return FeatureJsonConversions.toJson(this).toString(1);
        } catch (JSONException e) {
            throw new AssertionError("Not expected to be thrown");
        }
    }
}
