package ru.yandex.webmaster3.core.semantic.review_business.biz.model;

import org.json.JSONException;
import ru.yandex.webmaster3.core.semantic.review_business.ModelUtils;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json.BizReviewJsonConversions;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json.GeoJsonConversions;

/**
 * Coordinates wrapper.
 */
public abstract class Geo {

    abstract public Float getLatitude();

    abstract public Float getLongitude();

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof Geo)) return false;

        final Geo geo = (Geo) o;

        return hashCode() == geo.hashCode()
                && ModelUtils.equals(getLatitude(), geo.getLatitude())
                && ModelUtils.equals(getLongitude(), geo.getLongitude())
                ;
    }

    @Override
    public int hashCode() {
        return ModelUtils.hashCode(
                getLatitude(),
                getLongitude()
        );
    }

    /**
     * Construct string representation of Geo.
     */
    @Override
    public String toString() {
        try {
            return GeoJsonConversions.toJson(this).toString(1);
        } catch (JSONException e) {
            throw new AssertionError("Not expected to be thrown");
        }
    }
}

