package ru.yandex.webmaster3.core.semantic.review_business.biz.model;

import java.util.Collection;

import static org.apache.commons.collections.CollectionUtils.isEmpty;

/**
 * Some methods for create pretty toString within model classes.
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class ToStringUtils {
    private ToStringUtils() {
    }

    public static void append(final StringBuilder sb,
                              final String key,
                              final Object value) {
        if (value != null) {
            sb.append(key).append("=").append(value).append(", ");
        }
    }

    public static <T> void append(final StringBuilder sb,
                                  final String key,
                                  final Collection<T> values) {
        if (!isEmpty(values)) {
            sb.append(key).
                    append("=").
                    append(String.valueOf(values)).
                    append(", ");
        }
    }
}
