package ru.yandex.webmaster3.core.semantic.review_business.biz.model;

import com.google.common.collect.Lists;

import java.util.Collection;
import java.util.Date;


/**
 * TODO
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public final class Utils {
    private Utils() {

    }

    /**
     * @param c1  first collection
     * @param c2  second collection
     * @param <T> collection element type
     * @return true if collections contain same elements in the same order
     *         or false otherwise
     */
    public static <T> boolean equalsCollections(final Collection<T> c1,
                                                final Collection<T> c2) {
        if (c1 == c2)
            return true;
        if (c1 == null)
            return false;
        if (c1.size() != c2.size())
            return false;
        return Lists.newArrayList(c1).equals(Lists.newArrayList(c2));
    }

    /**
     * Compare dates ignore milliseconds
     *
     * @param d1 date to be compared
     * @param d2 date to be compared
     * @return true if dates are equals to seconds
     *         (not milliseconds as Date.equals works)
     */
    public static boolean equalsDates(final Date d1, final Date d2) {
        if (d1 == d2)
            return true;
        if (d1 == null)
            return false;
        return (d1.getTime() / 1000) == (d2.getTime() / 1000);
    }
}

