package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl;

/**
 * Holder for attribute names of BizReview.
 * <p/>
 * Attribute names must be equals to ones in BizReview.xsd
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public final class BizReviewAttributes {

    private BizReviewAttributes() {
        throw new UnsupportedOperationException("Not expected to be instantiated");
    }

    public static final String ID = "id";

    public static final String BIZ_ID = "biz-id";

    public static final String AUTO_BIZ_ID = "auto-biz-id";

    public static final String EXCLUDED_BIZ_IDS = "excluded-biz-ids";

    public static final String CHAIN_ID = "chain-id";

    public static final String CATEGORY = "category";

    public static final String BIZ_RUBRICS = "biz-rubrics";

    public static final String BIZ_RUBRIC = "biz-rubric";

    public static final String LANGUAGE = "language";

    /**
     * Use BIZ_ID instead.
     */
    @Deprecated
    public static final String LEGACY_BIZ_ID = "org-id";

    public static final String RATING = "rating";

    public static final String BEST_RATING = "best-rating";

    public static final String WORST_RATING = "worst-rating";

    public static final String SUMMARY = "summary";

    public static final String DESCRIPTION = "description";

    public static final String REVIEWER = "reviewer";

    public static final String VCARD = "vcard";

    public static final String REVIEWED_DATE = "dtreviewed";

    public static final String VISITED_DATE = "dtvisited";

    public static final String ITEM = "item";

    /**
     * Use VCARD instead
     */
    @Deprecated
    public static final String H_CARD = "hcard";

    public static final String PROS = "pros";

    public static final String PRO = "pro";

    public static final String CONTRAS = "contras";

    public static final String CONTRA = "contra";

    public static final String USEFUL = "useful";

    public static final String USELESS = "useless";

    public static final String LIKES = "likes";

    public static final String COMMENTS = "comments";

    public static final String REVIEWS_URL = "reviewsurl";

    public static final String COMMENT_URL = "commenturl";

    public static final String TAGS = "tags";

    public static final String FACTS = "facts";

    public static final String TAG = "tag";

    public static final String FACT = "fact";

    public static final String URL = "url";

    public static final String PERMANENT_ID = "permanent-id";

    public static final String VERSION_ID = "version-id";

    public static final String SOURCE_ID = "domain-id"; // by legacy

    public static final String ORIGIN_REVIEW = "origin-review";

    public static final String MODERATION = "moderation";

    public static final String MODERATION_HISTORY = "moderation-history";

    public static final String MODERATION_HISTORY_ELEMENT = "moderation-history-element";

    public static final String IS_DELETED = "is-deleted";

    public static final String WATCH_TIME = "watch-time";

    public static final String SPECIALIST_ID = "specialist-id";

    public static final String IS_VERIFIED = "is-verified";

    public static final String GEO = "geo";

    public static final String LATITUDE = "latitude";

    public static final String LONGITUDE = "longitude";
}

