package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Address;

import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.AddressAttributes.*;

/**
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public final class AddressJsonConversions {

    private static final Logger log = LoggerFactory.getLogger(AddressJsonConversions.class);

    /**
     * Use {@link #JSON_STRING_TO_ADDRESS} instead
     */
    @Deprecated
    public static final Function<JSONObject, Address> JSON_TO_ADDRESS =
            new Function<JSONObject, Address>() {
                @Override
                public Address apply(final JSONObject json) {
                    return fromJson(json);
                }
            };

    /**
     * Use {@link #ADDRESS_TO_JSON_STRING} instead
     */
    @Deprecated
    public static final Function<Address, JSONObject> ADDRESS_TO_JSON =
            new Function<Address, JSONObject>() {
                @Override
                public JSONObject apply(final Address address) {
                    return safeToJson(address);
                }
            };

    public static final Function<String, Address> JSON_STRING_TO_ADDRESS =
            new Function<String, Address>() {
                @Override
                public Address apply(final String json) {
                    return safeFromJson(json);
                }
            };

    public static final Function<Address, String> ADDRESS_TO_JSON_STRING =
            new Function<Address, String>() {
                @Override
                public String apply(final Address address) {
                    return safeToJsonString(address);
                }
            };

    private AddressJsonConversions() {
    }

    /**
     * Use {@link #fromJson(String)} (throws {@link JSONException}) and {@link #safeFromJson(String)} instead
     */
    @Deprecated
    public static Address fromJson(final JSONObject json) {
        return new AddressOverJson(json);
    }

    public static Address fromJson(final String json) throws JSONException {
        return new AddressOverJson(json);
    }

    public static Address safeFromJson(final String json) {
        try {
            return fromJson(json);
        } catch (JSONException e) {
            log.error("Error while parsing Address from json", e);
            return null;
        }
    }

    /**
     * Use {@link #toJsonString(ru.yandex.webmaster3.core.semantic.review_business.biz.model.Address)} instead
     */
    @Deprecated
    public static JSONObject toJson(final Address address) throws JSONException {
        Preconditions.checkNotNull(address, "Unable to convert null Address to JSON");
        return new JSONObject().
                putOpt(COUNTRY_NAME, address.getCountryName()).
                putOpt(REGION, address.getRegion()).
                putOpt(LOCALITY, address.getLocality()).
                putOpt(STREET_ADDRESS, address.getStreetAddress()).
                putOpt(EXTENDED_ADDRESS, address.getExtendedAddress()).
                putOpt(POSTAL_CODE, address.getPostalCode());
    }

    public static String toJsonString(final Address address) throws JSONException {
        JSONObject obj;
        obj = toJson(address);
        return obj.toString();
    }

    /**
     * Use {@link #safeToJsonString(ru.yandex.webmaster3.core.semantic.review_business.biz.model.Address)} instead
     */
    @Deprecated
    public static JSONObject safeToJson(final Address address) {
        try {
            return toJson(address);
        } catch (JSONException e) {
            log.error("Error while convert Address to JSON", e);
            return null;
        }
    }

    public static String safeToJsonString(final Address address) {
        try {
            return toJsonString(address);
        } catch (JSONException e) {
            log.error("Error while convert Address to JSON", e);
            return null;
        }
    }
}

