package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Address;

import static com.google.common.base.Strings.emptyToNull;
import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.AddressAttributes.*;

/**
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class AddressOverJson extends Address {
    private final JSONObject json;

    /**
     * This implementation breaks the contract for hashCode (because hashCode is counted
     * on top of all get methods of Object and JSONObject is mutable and cannot be controlled from
     * this implementation)
     * Visibility will be changed to package private (in case of necessity
     * of usage in constructing of high-level objects) or removed completely
     */
    @Deprecated
    public AddressOverJson(final JSONObject json) {
        Preconditions.checkNotNull(json, "Unable to create Address over null JSON");
        this.json = json;
    }
    public AddressOverJson(final String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create Address over empty JSON string");
        this.json = new JSONObject(json);
    }

    @Override
    public String getCountryName() {
        return json.optString(COUNTRY_NAME, null);
    }

    @Override
    public String getRegion() {
        return json.optString(REGION, null);
    }

    @Override
    public String getLocality() {
        return json.optString(LOCALITY, null);
    }

    @Override
    public String getStreetAddress() {
        return json.optString(STREET_ADDRESS, null);
    }

    @Override
    public String getExtendedAddress() {
        return json.optString(EXTENDED_ADDRESS, null);
    }

    @Override
    public String getPostalCode() {
        return json.optString(POSTAL_CODE, null);
    }
}

