package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Complaint;
import ru.yandex.webmaster3.core.semantic.review_business.util.DateHelper;

import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.ComplaintAttributes.*;

/**
 * TODO
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class ComplaintJsonConversion {
    private static final Logger log = LoggerFactory.getLogger(ComplaintJsonConversion.class);

    private ComplaintJsonConversion() {
    }

    /**
     * Use {@link #fromJson(String)} (throws {@link JSONException}) and {@link #safeFromJson(String)} instead
     */
    @Deprecated
    public static Complaint fromJson(final JSONObject json) {
        return new ComplaintOverJson(json);
    }

    public static Complaint fromJson(final String json) throws JSONException {
        return new ComplaintOverJson(json);
    }

    public static Complaint safeFromJson(final String json) {
        try {
            return fromJson(json);
        } catch (JSONException e) {
            log.error("Error while parsing Complaint from json", e);
            return null;
        }
    }

    /**
     * Use {@link #toJsonString(ru.yandex.webmaster3.core.semantic.review_business.biz.model.Complaint)} instead
     */
    @Deprecated
    public static JSONObject toJson(final Complaint complaint)
            throws JSONException {
        return new JSONObject().
                putOpt(ID, complaint.getId()).
                putOpt(BIZ_ID, complaint.getBizId()).
                putOpt(REVIEW_ID, complaint.getReviewId()).
                putOpt(REASON_ID, complaint.getReason()).
                putOpt(TEXT, complaint.getText()).
                putOpt(CREATE_DATE, DateHelper.safeWrite(complaint.getCreationDate())).
                putOpt(CHECK_STATUS_ID, complaint.getCheckStatus()).
                putOpt(CHECK_MESSAGE, complaint.getCheckMessage()).
                putOpt(HANDLER_UID, complaint.getHandlerUid()).
                putOpt(HANDLED_TIME, DateHelper.safeWrite(complaint.getHandledTime()));

    }

    public static String toJsonString(final Complaint complaint) throws JSONException {
        JSONObject obj;
        obj = toJson(complaint);
        return obj.toString();
    }

    /**
     * Use {@link #safeToJsonString(ru.yandex.webmaster3.core.semantic.review_business.biz.model.Complaint)} instead
     */
    @Deprecated
    public static JSONObject safeToJson(final Complaint complaint) {
        try {
            return toJson(complaint);
        } catch (JSONException e) {
            log.error("Error while convert complaint to JSON", e);
            return null;
        }
    }

    public static String safeToJsonString(final Complaint complaint) {
        try {
            return toJsonString(complaint);
        } catch (JSONException e) {
            log.error("Error while convert complaint to JSON", e);
            return null;
        }
    }
}

